/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.inner;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.inner.PayPacker;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.inner.PayParser;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.inner.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PaymentImpl
extends AbstractPayImpl {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri(Packer.getURL());
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "CostReimb";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u8d39\u7528\u62a5\u9500(CostReimb)", (String)"PaymentImpl_5", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        if (!BankBusinessConfig.isCompanySubAc(paymentInfo.getAccNo())) {
            if ("pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType())) {
                return UseConvertor.isReim((PaymentInfo)paymentInfo) && !paymentInfo.is2Merge() && paymentInfo.is2SameBank();
            }
            if ("pay".equalsIgnoreCase(paymentInfo.getSubBizType())) {
                return !UseConvertor.isSalary((PaymentInfo)paymentInfo) && !UseConvertor.isTransfer((PaymentInfo)paymentInfo) && !BankBusinessConfig.isVirtualAccount(paymentInfo.getAccNo()) && paymentInfo.is2Individual() && !BankBusinessConfig.isUseOnlinePay() && paymentInfo.is2SameBank();
            }
        }
        return false;
    }

    public String pack(BankPayRequest request) {
        return PayPacker.packPay(request.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return PayParser.parsePay(request.getPaymentInfoAsArray(), responseStr);
    }
}

