/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hdb.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hdb.dc.services.HDBCommPacker;
import kd.ebg.aqap.banks.hdb.dc.services.HDBCommParser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = HDBCommPacker.packCommHeader("B2EActTrsQry");
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        Element listElement = JDomUtils.addChild((Element)body, (String)"List");
        Element mapElement = JDomUtils.addChild((Element)listElement, (String)"Map");
        JDomUtils.addChild((Element)mapElement, (String)"AcNo", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)mapElement, (String)"Currency", (String)bankDetailRequest.getAcnt().getCurrency());
        JDomUtils.addChild((Element)mapElement, (String)"BeginDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)mapElement, (String)"EndDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        BankResponse resp = HDBCommParser.parserCommonHead(s);
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        if (!"000000".equals(resp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\u4e3a:%s", (String)"DetailImpl_9", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]), resp.toString()));
        }
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        try {
            Element mapElement = root.getChild("Body").getChild("List").getChild("Map");
            String returnCode = mapElement.getChildTextTrim("ReturnCode");
            String returnMsg = mapElement.getChildTextTrim("ReturnMsg");
            if (!"000000".equals(returnCode)) {
                return new EBBankDetailResponse(detailInfos);
            }
            String acNo = mapElement.getChildTextTrim("AcNo");
            if (!bankDetailRequest.getAcnt().getAccNo().equals(acNo)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\u4e3a:\u8bf7\u6c42\u8d26\u53f7[%1$s]\u4e0e\u94f6\u884c\u8fd4\u56de\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\u3002", (String)"DetailImpl_10", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]), bankDetailRequest.getAcnt().getAccNo(), acNo));
            }
            Element listElement2 = mapElement.getChild("List");
            if (null == listElement2) {
                return new EBBankDetailResponse(detailInfos);
            }
            List rowList = listElement2.getChildren("Map");
            if (rowList == null || rowList.size() == 0) {
                return new EBBankDetailResponse(detailInfos);
            }
            for (int i = 0; i < rowList.size(); ++i) {
                String transTimeStr;
                Element row = (Element)rowList.get(i);
                String transDate = row.getChildTextTrim("TransDate");
                String transTime = row.getChildTextTrim("TransTime");
                String cur = row.getChildTextTrim("Currency");
                String cd_flag = row.getChildTextTrim("DCFlag");
                String tran_amount = row.getChildTextTrim("Amount");
                String balance = row.getChildTextTrim("Balance");
                String remark = row.getChildTextTrim("Remark");
                String oppAcctNo = row.getChildTextTrim("PartnerAcct");
                String oppAccName = row.getChildTextTrim("PartnerAcName");
                DetailInfo detailInfo = new DetailInfo();
                detailInfo.setAccName(bankDetailRequest.getAcnt().getAccName());
                detailInfo.setAccNo(bankDetailRequest.getAcnt().getAccNo());
                detailInfo.setOppAccName(oppAccName);
                detailInfo.setOppAccNo(oppAcctNo);
                detailInfo.setOppBankName("");
                detailInfo.setCurrency(cur);
                if (!StringUtils.isEmpty((String)transDate)) {
                    detailInfo.setTransDate(LocalDate.parse(transDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                    transTimeStr = transDate + transTime;
                    if (StringUtils.isEmpty((String)transTime)) {
                        transTimeStr = transDate + "000000";
                    }
                } else {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"DetailImpl_4", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]));
                }
                detailInfo.setTransTime(LocalDateTime.parse(transTimeStr, DateTimeFormatter.ofPattern("yyyy-MM-ddHHmmss")));
                if ("C".equals(cd_flag)) {
                    detailInfo.setCreditAmount(new BigDecimal(tran_amount));
                    detailInfo.setDebitAmount(new BigDecimal("0.00"));
                } else if ("D".equals(cd_flag)) {
                    detailInfo.setCreditAmount(new BigDecimal("0.00"));
                    detailInfo.setDebitAmount(new BigDecimal(tran_amount));
                } else {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u501f\u8d37\u65b9\u5411<DCFlag>\u4e3a%s,\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u7684\u501f\u8d37\u65b9\u5411", (String)"DetailImpl_12", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]), cd_flag));
                }
                if (!StringUtils.isEmpty((String)balance)) {
                    detailInfo.setBalance(new BigDecimal(balance));
                }
                detailInfo.setExplanation(remark);
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
                detailInfo.setJsonMap(jsonStr);
                detailInfos.add(detailInfo);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u89e3\u6790\u51fa\u9519\u3002", (String)"DetailImpl_7", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EActTrsQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u90af\u90f8\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_8", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder uri = new StringBuilder();
        uri.append("/eweb/").append(this.getBizCode()).append(".do?");
        String accessNumber = RequestContextUtils.getBankParameterValue((String)"passWord");
        String signFlag = "1";
        uri.append("userPassword=").append(accessNumber).append("&SIGDATA=").append(signFlag);
        factory.setUri(uri.toString());
    }
}

