/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hdb.dc.services.payment;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hdb.dc.services.HDBCommParser;
import kd.ebg.aqap.banks.hdb.dc.services.payment.QryPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OuterPaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(OuterPaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String xmlMsg = "";
        Element root = new Element("Message");
        Element head = JDomUtils.addChild((Element)root, (String)"Head");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        JDomUtils.addChild((Element)head, (String)"ERPJnlNo", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)"B2ECrossBankTransfer");
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        Element listElement = JDomUtils.addChild((Element)body, (String)"List");
        for (PaymentInfo info : paymentInfos) {
            Element mapElement = JDomUtils.addChild((Element)listElement, (String)"Map");
            JDomUtils.addChild((Element)mapElement, (String)"PayerAcNo", (String)info.getAccNo());
            JDomUtils.addChild((Element)mapElement, (String)"PayerAcName", (String)info.getAccName());
            JDomUtils.addChild((Element)mapElement, (String)"PayeeAcNo", (String)info.getIncomeAccNo());
            JDomUtils.addChild((Element)mapElement, (String)"PayeeAcName", (String)info.getIncomeAccName());
            JDomUtils.addChild((Element)mapElement, (String)"Amount", (String)BigDecimalHelper.plain2((BigDecimal)info.getAmount()));
            JDomUtils.addChild((Element)mapElement, (String)"Currency", (String)info.getCurrency());
            JDomUtils.addChild((Element)mapElement, (String)"DrecCode", (String)info.getIncomeCnaps());
            JDomUtils.addChild((Element)mapElement, (String)"UnionDeptId", (String)info.getIncomeCnaps());
            JDomUtils.addChild((Element)mapElement, (String)"PayeeBankName", (String)info.getIncomeBankName());
            JDomUtils.addChild((Element)mapElement, (String)"Remark", (String)info.getExplanation());
            JDomUtils.addChild((Element)mapElement, (String)"Priority", (String)"1");
        }
        xmlMsg = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        return xmlMsg;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BankResponse resp = HDBCommParser.parserCommonHead(s);
        if ("000000".equals(resp.getResponseCode())) {
            Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
            Element mapElement = root.getChild("Body").getChild("List").getChild("Map");
            String returnCode = mapElement.getChildTextTrim("ReturnCode");
            String returnMsg = mapElement.getChildTextTrim("ReturnMsg");
            resp.setResponseCode(returnCode);
            resp.setResponseMessage(returnMsg);
            if ("000000".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u884c\u6210\u529f\u3002", (String)"OuterPaymentImpl_0", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]), (String)resp.getResponseCode(), (String)resp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\u3002", (String)"OuterPaymentImpl_1", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]), (String)resp.getResponseCode(), (String)resp.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u975e\u6210\u529f\u72b6\u6001\u7801,\u4ea4\u6613\u672a\u786e\u8ba4\u3002", (String)"OuterPaymentImpl_2", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]), (String)resp.getResponseCode(), (String)resp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2ECrossBankTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u90af\u90f8\u94f6\u884c\u5bf9\u516c\u652f\u4ed8\u63a5\u53e3\u3002", (String)"OuterPaymentImpl_3", (String)"ebg-aqap-banks-hdb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !paymentInfo.is2SameBank();
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder uri = new StringBuilder();
        uri.append("/eweb/").append(this.getBizCode()).append(".do?");
        String accessNumber = RequestContextUtils.getBankParameterValue((String)"passWord");
        String signFlag = "1";
        uri.append("userPassword=").append(accessNumber).append("&SIGDATA=").append(signFlag);
        factory.setUri(uri.toString());
    }
}

