/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.opa.services.apply;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.opa.services.utils.BOCRequest;
import kd.ebg.aqap.banks.boc.opa.services.utils.BOCUtil;
import kd.ebg.aqap.business.apply.atomic.AbstractApplyImpl;
import kd.ebg.aqap.business.apply.atomic.IApply;
import kd.ebg.aqap.business.apply.bank.BankApplyRequest;
import kd.ebg.aqap.business.apply.bank.EBBankApplyResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ApplyImpl
extends AbstractApplyImpl
implements IApply {
    public String pack(BankApplyRequest bankApplyRequest) {
        BOCRequest request = new BOCRequest();
        BOCRequest.MsgBody msgBody = new BOCRequest.MsgBody();
        JSONObject data = new JSONObject();
        data.put("signReqNo", (Object)Sequence.gen18Sequence());
        String validDate = LocalDate.now().plusDays(364L).format(DateTimeFormatter.BASIC_ISO_DATE);
        data.put("validDate", (Object)validDate);
        data.put("accountNum", (Object)bankApplyRequest.getAcnt().getAccNo());
        data.put("accountName", (Object)bankApplyRequest.getAcnt().getAccName());
        JSONArray funcList = new JSONArray();
        String bsnStr = bankApplyRequest.getBsnStr();
        if (StringUtils.isEmpty((String)bsnStr)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5f00\u901a\u7684\u529f\u80fd", (String)"ApplyImpl_0", (String)"ebg-aqap-banks-boc-opa", (Object[])new Object[0]));
        }
        ArrayList bsnList = Lists.newArrayList((Object[])bsnStr.split(","));
        bsnList.sort(Comparator.naturalOrder());
        funcList.addAll((Collection)bsnList);
        data.put("functionList", (Object)funcList);
        msgBody.setData(data.toJSONString());
        request.setMsgBody(msgBody);
        return BOCUtil.goRequest(request, bankApplyRequest.getHeader().getCustomerID());
    }

    public EBBankApplyResponse parse(BankApplyRequest bankApplyRequest, String s) {
        JSONObject data = BOCUtil.handleResponse(s);
        String triSignId = data.getString("triSignId");
        String triSignUrl = data.getString("triSignUrl");
        return new EBBankApplyResponse(triSignId, triSignUrl);
    }

    public String getDeveloper() {
        return "cw";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/eztdg-framework/igtb/sign/v1/signRequest");
        factory.setHttpHeader("from_product", "third");
        factory.setHttpHeader("target_product", "IGTBNET-LCA");
        factory.setHttpHeader("Content-type", "application/json");
        factory.setHttpHeader("interaction_id", "o.tdg.igtbnet-lca0010");
    }
}

