/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.opa.services.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.opa.BankBussinessConfig;
import kd.ebg.aqap.banks.boc.opa.services.utils.BOCRequest;
import kd.ebg.aqap.banks.boc.opa.services.utils.GmUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.CertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.CipherInfoUtil;
import kd.ebg.egf.common.utils.DesUtil;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.util.encoders.Base64;

public class BOCUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BOCUtil.class);
    public static final String SM4_ECB_PKCS7PADDING = "SM4/ECB/PKCS7Padding";
    protected static byte[] sm4Key;
    public static final String DATE_FORMAT = "yyyyMMdd HH:mm:ss";
    public static final String GAP = "&";
    private static final Map<String, String> prod;

    public static String goRequest(BOCRequest req, String customId) {
        BOCRequest.MsgHead msgHead = new BOCRequest.MsgHead();
        msgHead.setAppId(BankBussinessConfig.getAppId(customId));
        msgHead.setTimestamp(LocalDateTime.now().format(DateTimeFormatter.ofPattern(DATE_FORMAT)));
        msgHead.setRequestId(Sequence.genSequence());
        req.setMsgHead(msgHead);
        String signSourceStr = req.toString();
        try {
            msgHead.setSign(BOCUtil.sign(signSourceStr));
            BOCRequest.MsgBody msgBody = req.getMsgBody();
            msgBody.setData(BOCUtil.encrypt(msgBody.getData()));
            msgHead.setEncryptKey(BOCUtil.encryptKeyWithOppPubKey());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u52a0\u5bc6\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38", (String)"BOCUtil_0", (String)"ebg-aqap-banks-boc-opa", (Object[])new Object[0]), (Throwable)e);
        }
        return JSON.toJSONString((Object)req);
    }

    public static JSONObject handleResponse(String s) {
        String responseMessage;
        JSONObject response = JSONObject.parseObject((String)s);
        JSONObject msgHead = response.getJSONObject("msgHead");
        JSONObject msgBody = response.getJSONObject("msgBody");
        String appId = msgHead.getString("appId");
        String requestId = msgHead.getString("requestId");
        String signId = msgHead.getString("signId");
        String signMethod = msgHead.getString("signMethod");
        String encryptType = msgHead.getString("encryptType");
        String timestamp = msgHead.getString("timestamp");
        String signStr = msgHead.getString("sign");
        String encryptKey = msgHead.getString("encryptKey");
        String code = msgHead.getString("responseCode");
        if (!BOCUtil.checkCodes(code, responseMessage = msgHead.getString("responseMessage"))) {
            return BOCUtil.responseBody(code, responseMessage);
        }
        String data = msgBody.getString("data");
        StringBuilder sb = new StringBuilder();
        try {
            String sourceData = BOCUtil.decrypt(data, encryptKey);
            sb.append(appId).append(GAP).append(requestId).append(GAP).append(timestamp).append(GAP).append(signId).append(GAP).append(signMethod).append(GAP).append(encryptType).append(GAP).append(sourceData);
            logger.info("\u94f6\u884c\u54cd\u5e94\u7684\u5f85\u9a8c\u7b7e\u62a5\u6587->{}", (Object)sb.toString());
            PublicKey bocVPK = BOCUtil.getPlateFormPublicKeyForSign();
            if (!BOCUtil.verify(signStr, sb.toString(), bocVPK)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u9a8c\u7b7e\u4e0d\u901a\u8fc7", (String)"BOCUtil_1", (String)"ebg-aqap-banks-boc-opa", (Object[])new Object[0]));
            }
            return JSON.parseObject((String)sourceData);
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static JSONObject responseBody(String code, String responseMessage) {
        JSONObject resData = new JSONObject();
        JSONObject kdExt = new JSONObject();
        kdExt.put("code", (Object)code);
        kdExt.put("msg", (Object)responseMessage);
        resData.put("kdExt", (Object)kdExt);
        logger.info("\u54cd\u5e94\u9519\u8bef\u7801{}", (Object)resData.toJSONString());
        return resData;
    }

    public static boolean checkCodes(String code, String responseMessage) {
        if ("RT0003".equalsIgnoreCase(code)) {
            return false;
        }
        if ("RT0000".equalsIgnoreCase(code)) {
            return true;
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4e1a\u52a1\u8bf7\u6c42\u94f6\u884c\u53cd\u9988\u672a\u6210\u529f,\u4ea4\u6613\u7801\u3010%1$s\u3011\uff0c\u54cd\u5e94\u4fe1\u606f\u3010%2$s\u3011", (String)"BOCUtil_7", (String)"ebg-aqap-banks-boc-opa", (Object[])new Object[0]), code, responseMessage));
    }

    public static String encrypt(String msg) throws UnsupportedEncodingException {
        logger.info("\u5f85\u52a0\u5bc6\u4e32->" + msg);
        sm4Key = GmUtil.generateSM4Key();
        String b64Body = Base64.toBase64String((byte[])msg.getBytes("UTF-8"));
        byte[] result = GmUtil.sm4Encrypt(sm4Key, b64Body.getBytes(StandardCharsets.UTF_8), SM4_ECB_PKCS7PADDING);
        return Base64.toBase64String((byte[])result);
    }

    public static String decrypt(String msg, String encryptKey) throws UnsupportedEncodingException {
        BCECPrivateKey privateKey = BOCUtil.getPlateFormPrivateKeyForEncryption();
        byte[] symmKeyCipher = Base64.decode((String)encryptKey);
        byte[] bodyCipher = Base64.decode((String)msg);
        byte[] data = new byte[]{4};
        byte[] decryptedText = new byte[symmKeyCipher.length + 1];
        System.arraycopy(data, 0, decryptedText, 0, data.length);
        System.arraycopy(symmKeyCipher, 0, decryptedText, data.length, symmKeyCipher.length);
        byte[] symmKey = GmUtil.sm2Decrypt(decryptedText, (PrivateKey)privateKey);
        byte[] b64Body = GmUtil.sm4Decrypt(symmKey, bodyCipher, SM4_ECB_PKCS7PADDING);
        return new String(Base64.decode((byte[])b64Body), "UTF-8");
    }

    public static String sign(String msg) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchProviderException, SignatureException {
        logger.info("\u5f85\u7b7e\u540d\u4e32->" + msg);
        BCECPrivateKey privateKey = BOCUtil.getPlateFormPrivateKeyForSign();
        byte[] userId = "1234567812345678".getBytes();
        byte[] sig = GmUtil.signSm3WithSm2Asn1Rs(msg.getBytes("UTF-8"), userId, (PrivateKey)privateKey);
        return Base64.toBase64String((byte[])sig);
    }

    public static boolean verify(String b64Sign, String signSourceData, PublicKey key) throws UnsupportedEncodingException {
        byte[] userId = "1234567812345678".getBytes();
        byte[] sign = Base64.decode((String)b64Sign);
        return GmUtil.verifySm3WithSm2Asn1Rs(signSourceData.getBytes("UTF-8"), userId, sign, key);
    }

    public static String encryptKeyWithOppPubKey() {
        PublicKey bocPK1 = BOCUtil.getPlateFormPublicKeyForEncryption();
        byte[] encryptKey = GmUtil.sm2Encrypt(sm4Key, bocPK1);
        byte[] res = Arrays.copyOfRange(encryptKey, 1, encryptKey.length);
        return Base64.toBase64String((byte[])res);
    }

    private static BCECPrivateKey getPlateFormPrivateKeyForSign() {
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(RequestContextUtils.getRequestContext().getBankVersionID(), "plateForm_private_certInfo");
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u7528\u6237\u79c1\u94a5\u8bc1\u4e66", (String)"BOCUtil_4", (String)"ebg-aqap-banks-boc-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = CipherInfoUtil.getCipherInfo((String)certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        String privateKeyStr = CipherInfoUtil.getKey((byte[])fileContent);
        JSONObject ePair = JSONObject.parseObject((String)privateKeyStr);
        privateKeyStr = ePair.getString("s");
        try {
            BigInteger bi = new BigInteger(privateKeyStr, 16);
            return GmUtil.getPrivatekeyFromD(bi);
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u83b7\u53d6\u79d8\u94a5\u5931\u8d25", (String)"BOCUtil_5", (String)"ebg-aqap-banks-boc-opa", (Object[])new Object[0]));
        }
    }

    private static BCECPrivateKey getPlateFormPrivateKeyForEncryption() {
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(RequestContextUtils.getRequestContext().getBankVersionID(), "plateForm_private_certInfo");
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u5148\u914d\u7f6e\u7528\u6237\u79c1\u94a5\u8bc1\u4e66", (String)"BOCUtil_4", (String)"ebg-aqap-banks-boc-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = CipherInfoUtil.getCipherInfo((String)certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        String privateKeyStr = CipherInfoUtil.getKey((byte[])fileContent);
        JSONObject ePair = JSONObject.parseObject((String)privateKeyStr);
        privateKeyStr = ePair.getString("e");
        try {
            BigInteger bi = new BigInteger(privateKeyStr, 16);
            return GmUtil.getPrivatekeyFromD(bi);
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u83b7\u53d6\u79d8\u94a5\u5931\u8d25", (String)"BOCUtil_5", (String)"ebg-aqap-banks-boc-opa", (Object[])new Object[0]));
        }
    }

    private static PublicKey getPlateFormPublicKeyForEncryption() {
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(RequestContextUtils.getRequestContext().getBankVersionID(), "plateForm_public_certInfo");
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25\uff0c\u8054\u7cfb\u94f6\u4f01\u4e91\u7ba1\u7406\u5458\u914d\u7f6e\u94f6\u884c\u516c\u94a5\u8bc1\u4e66", (String)"BOCUtil_6", (String)"ebg-aqap-banks-boc-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = CipherInfoUtil.getCipherInfo((String)certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        String publicKeyStr = CipherInfoUtil.getKey((byte[])fileContent);
        JSONObject ePair = JSONObject.parseObject((String)publicKeyStr);
        publicKeyStr = ePair.getString("e");
        String x = publicKeyStr.substring(0, 64);
        String y = publicKeyStr.substring(64, 128);
        return GmUtil.getPublickeyFromXY(new BigInteger(x, 16), new BigInteger(y, 16));
    }

    private static PublicKey getPlateFormPublicKeyForSign() {
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(RequestContextUtils.getRequestContext().getBankVersionID(), "plateForm_public_certInfo");
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25\uff0c\u8054\u7cfb\u94f6\u4f01\u4e91\u7ba1\u7406\u5458\u914d\u7f6e\u94f6\u884c\u516c\u94a5\u8bc1\u4e66", (String)"BOCUtil_6", (String)"ebg-aqap-banks-boc-opa", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = CipherInfoUtil.getCipherInfo((String)certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        String publicKeyStr = CipherInfoUtil.getKey((byte[])fileContent);
        JSONObject ePair = JSONObject.parseObject((String)publicKeyStr);
        publicKeyStr = ePair.getString("s");
        String x = publicKeyStr.substring(0, 64);
        String y = publicKeyStr.substring(64, 128);
        return GmUtil.getPublickeyFromXY(new BigInteger(x, 16), new BigInteger(y, 16));
    }

    public static String getExclusiveAppID(String access) {
        if (access.startsWith("JDY")) {
            access = "JDY";
        } else if (access.startsWith("YKJ")) {
            access = "YKJ";
        } else if (access.startsWith("PRO")) {
            access = "PRO";
        }
        if ("prod".equals(System.getProperty("ebg.server.env"))) {
            return prod.getOrDefault(access, "100301");
        }
        return "100062";
    }

    static {
        prod = new HashMap<String, String>(2);
        prod.put("JDY", "100301");
        prod.put("YKJ", "100342");
        prod.put("PRO", "100361");
    }
}

