/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.acct.MappingAcctRequest;
import kd.ebg.aqap.common.entity.biz.apply.ApplyRequest;
import kd.ebg.aqap.common.entity.biz.apply.QueryApplyRequest;
import kd.ebg.aqap.common.entity.biz.balance.BatchBalanceRequest;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.BalanceReconciliationRequest;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.BalanceStatementRequest;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.QueryBalanceReconciliationRequest;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.UpdateBalanceReconciliationStatusRequest;
import kd.ebg.aqap.common.entity.biz.bankloginconfig.BankLoginConfigRequest;
import kd.ebg.aqap.common.entity.biz.banklogindetail.BankLoginDetailRequest;
import kd.ebg.aqap.common.entity.biz.cafstatus.CafStatusRequest;
import kd.ebg.aqap.common.entity.biz.cert.CertRequest;
import kd.ebg.aqap.common.entity.biz.credit.QueryCreditReceivedRequest;
import kd.ebg.aqap.common.entity.biz.credit.QueryCreditRequest;
import kd.ebg.aqap.common.entity.biz.credit.openCredit.OpenCreditRequest;
import kd.ebg.aqap.common.entity.biz.credit.queryOpenCredit.QueryOpenCreditRequest;
import kd.ebg.aqap.common.entity.biz.curandfixed.CurrentAndFixedRequest;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.cancel.CurrentAndFixedExRequest;
import kd.ebg.aqap.common.entity.biz.detail.DetailRequest;
import kd.ebg.aqap.common.entity.biz.file.DownLoadFileRequest;
import kd.ebg.aqap.common.entity.biz.financing.buy.BuyFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.buy.QueryBuyFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.query.QueryFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.redeem.QueryRedeemFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.redeem.RedeemFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.status.FinancingStatusRequest;
import kd.ebg.aqap.common.entity.biz.linkpay.LinkPayRequest;
import kd.ebg.aqap.common.entity.biz.listbank.ListBankRequest;
import kd.ebg.aqap.common.entity.biz.listbanklogin.ListBankLoginRequest;
import kd.ebg.aqap.common.entity.biz.monitor.MonitorRequest;
import kd.ebg.aqap.common.entity.biz.param.ParamRequest;
import kd.ebg.aqap.common.entity.biz.pay.OverseaPayRequest;
import kd.ebg.aqap.common.entity.biz.pay.PayRequest;
import kd.ebg.aqap.common.entity.biz.pay.PayResponse;
import kd.ebg.aqap.common.entity.biz.paystatus.PayStatusRequest;
import kd.ebg.aqap.common.entity.biz.querycurandfixed.QueryCurAndFixedRequest;
import kd.ebg.aqap.common.entity.biz.querylinkpay.QueryLinkPayRequest;
import kd.ebg.aqap.common.entity.biz.querypay.QueryOverseaPayRequest;
import kd.ebg.aqap.common.entity.biz.querypay.QueryPayRequest;
import kd.ebg.aqap.common.entity.biz.register.RegisterRequest;
import kd.ebg.aqap.common.entity.biz.syncaccount.SyncAccountRequest;
import kd.ebg.aqap.common.entity.biz.syncbanklogin.SyncBankLoginRequest;
import kd.ebg.aqap.common.entity.biz.tenant.UpdateTenantRequest;
import kd.ebg.aqap.common.framework.exception.EBBaseException;
import kd.ebg.aqap.common.front.api.biz.EBResponseCode;
import kd.ebg.aqap.common.front.api.boot.utils.FrontCheckUtil;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.mservice.EBAsyncServiceImpl;
import kd.ebg.aqap.mservice.facade.config.FacadeProperties;
import kd.ebg.aqap.mservice.facade.utils.CommonUtils;
import kd.ebg.aqap.mservice.facade.utils.LogUtil;
import kd.ebg.aqap.mservice.impl.CustomizeService;
import kd.ebg.aqap.mservice.lang.MultiLang;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBException;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.entity.base.EBRequestEnhance;
import kd.ebg.egf.common.entity.base.EBResponse;
import kd.ebg.egf.common.entity.service.EBBaseRequest;
import kd.ebg.egf.common.entity.service.EBServiceRequest;
import kd.ebg.egf.common.entity.service.EBServiceResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBSecurityException;
import kd.ebg.egf.common.exception.message.EBExceptionMsgEnum;
import kd.ebg.egf.common.framework.security.util.EBFrontUtil;
import kd.ebg.egf.common.framework.service.tenant.TenantService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import net.sf.json.JSONObject;
import org.slf4j.MDC;

public class EBGateway
implements IBillWebApiPlugin {
    private static EBGateway instance = new EBGateway();
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(EBGateway.class);
    private static final String BANK_VERSION_ID = "bankVersionID";
    private static final long maxWaitTime = 30L;
    private static final RateLimiter globalRateLimiter = RateLimiter.create((double)1000.0);
    private static final AtomicInteger rateLimiterRejectCount = new AtomicInteger(0);
    private static final ConcurrentHashMap<String, RateLimiter> customRateLimiter = new ConcurrentHashMap();
    private TenantService tenantService;

    public static EBGateway getInstance() {
        return instance;
    }

    private synchronized RateLimiter createForCustom(String customId) {
        RateLimiter rateLimiter = customRateLimiter.get(customId);
        if (Objects.isNull(rateLimiter)) {
            rateLimiter = RateLimiter.create((double)100.0);
            customRateLimiter.put(customId, rateLimiter);
        }
        return rateLimiter;
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        return ApiResult.success((Object)"");
    }

    public ApiResult doCustomService(Map<String, Object> params) {
        MDCUtil.clearBussinessMDC();
        long currentMs = System.currentTimeMillis();
        ApiResult result = new ApiResult();
        EBServiceResponse response = null;
        String responseData = "";
        String jsonMap = JSON.toJSONString(params);
        EBServiceRequest request = (EBServiceRequest)JsonUtil.json2Obj((String)jsonMap, EBServiceRequest.class);
        FacadeProperties properties = (FacadeProperties)SpringContextUtil.getBean(FacadeProperties.class);
        try {
            EBRequestEnhance ebRequestEnhance;
            boolean tryAcquire;
            String customID = RequestContext.get().getTenantId();
            if (StringUtils.isEmpty((String)customID)) {
                throw new EBSecurityException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237[%s]\u4e0d\u5b58\u5728\u3002", (String)"EBGateway_0", (String)"ebg-aqap-mservice", (Object[])new Object[0]), customID));
            }
            if ("api".equalsIgnoreCase(RequestContext.get().getClient())) {
                this.tenantService = (TenantService)SpringContextUtil.getBean(TenantService.class);
                if (!(this.tenantService.isJDY(request.getCustomerID()) || (request.getCustomerID().startsWith("JDY") || request.getCustomerID().startsWith("YKJ") || request.getCustomerID().startsWith("PRO")) && "register".equals(request.getBizType()))) {
                    if ((request.getCustomerID().startsWith("JDY") || request.getCustomerID().startsWith("YKJ") || request.getCustomerID().startsWith("PRO")) && !"register".equals(request.getBizType())) {
                        throw new EBSecurityException(String.format(ResManager.loadKDString((String)"\u5c0f\u5fae\u4e1a\u52a1\u8bf7\u6c42\u79df\u6237\u53f7[%s]\u9519\u8bef", (String)"EBGateway_4", (String)"ebg-aqap-mservice", (Object[])new Object[0]), customID));
                    }
                    if (!StringUtils.equalsIgnoreCase((String)customID, (String)request.getCustomerID())) {
                        throw new EBSecurityException(EBExceptionMsgEnum.TENANT_MATCH_ERROR.getErrorMsg(new Object[]{customID}));
                    }
                    request.setCustomerID(customID);
                }
            } else {
                request.setCustomerID(customID);
            }
            if (!(tryAcquire = globalRateLimiter.tryAcquire(30L, TimeUnit.SECONDS))) {
                rateLimiterRejectCount.incrementAndGet();
                throw new EBSecurityException(MultiLang.getLimitTip());
            }
            RateLimiter rateLimiter = customRateLimiter.get(request.getCustomerID());
            if (Objects.isNull(rateLimiter)) {
                rateLimiter = this.createForCustom(request.getCustomerID());
            }
            if (!rateLimiter.tryAcquire(30L, TimeUnit.SECONDS)) {
                logger.info("\u79df\u6237:{} \u89e6\u53d1\u9650\u6d41", (Object)request.getCustomerID());
                throw new EBSecurityException(MultiLang.getSingleLimitTip());
            }
            FrontCheckUtil.checkRequest((EBBaseRequest)request);
            if (properties.isTimeLimitCheck() && !FrontCheckUtil.checkTimeLimited((EBBaseRequest)request, (long)properties.getTimeLimit(), (long)properties.getTimeTolerate())) {
                String time = String.valueOf(Math.abs(System.currentTimeMillis() - request.getTimestamp()));
                throw new EBSecurityException(MultiLang.getTSOverTimeTip(time));
            }
            boolean isIgnoreCheckSign = Boolean.parseBoolean(System.getProperty("ignoreCheckSign"));
            if ("register".equalsIgnoreCase(request.getBizType())) {
                isIgnoreCheckSign = false;
            }
            if (!isIgnoreCheckSign) {
                LogUtil.infoRequest((EBBaseRequest)request);
                boolean isValid = EBFrontUtil.decryptAndVerifyEBSecurityRequest((EBServiceRequest)request);
                if (!isValid) {
                    throw new EBSecurityException(MultiLang.getSignCheckErrorTip());
                }
            }
            try {
                ebRequestEnhance = (EBRequestEnhance)JsonUtil.json2Obj((String)request.getData().trim(), EBRequestEnhance.class);
            }
            catch (JSONException e) {
                throw new EBSecurityException(MultiLang.getEncryptCheckErrorTip());
            }
            LogUtil.debugRequest((EBBaseRequest)request);
            String data = request.getData().trim();
            data = data.replaceAll("\u200b", "");
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)data), (Object)MultiLang.getDataEmptyTip());
            String bizType = request.getBizType();
            String customId = request.getCustomerID();
            String requestSeqID = "";
            String bizSeqID = Sequence.gen18Sequence();
            String batchSeqId = ebRequestEnhance.getBody().getBatchSeqId();
            if (!StringUtils.isEmpty((String)batchSeqId)) {
                bizSeqID = batchSeqId;
            }
            if ("ping".equalsIgnoreCase(ebRequestEnhance.getHeader().getBizType())) {
                MDC.put((String)BANK_VERSION_ID, (String)ebRequestEnhance.getHeader().getExtData());
            }
            requestSeqID = String.valueOf(ebRequestEnhance.getHeader().getRequestTime());
            ebRequestEnhance.setLogRequestSeqId(requestSeqID);
            ebRequestEnhance.setCustomId(customId);
            ebRequestEnhance.setLogBizSeqId(bizSeqID);
            String logger_bank_no = Sequence.gen18Sequence();
            EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).logRequestSeqID(requestSeqID).bizName(bizType).subBizName(bizType).bankVersionID("").logBizSeqID(bizSeqID).bizSeqID(Sequence.gen18Sequence()).requestSeqID(Sequence.genSequence()).loggerBatchNo(bizSeqID).loggerDetailNo(bizSeqID).loggerBankNo(logger_bank_no).build();
            EBContext.setContext((EBContext)context);
            JSONObject object = new JSONObject();
            object.put((Object)"loggerBatchNo", (Object)bizSeqID);
            object.put((Object)"loggerDetailNo", (Object)bizSeqID);
            object.put((Object)"loggerBankNo", (Object)logger_bank_no);
            ebRequestEnhance.getHeader().setExtData(object.toString());
            MDCUtil.initMDC();
            logger.infoRequest("\u8bf7\u6c42\u6570\u636e: \n{}", (Object)CommonUtils.prettyJson(data));
            PayResponse ebResponse = null;
            try {
                switch (bizType) {
                    case "batchBalance": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"batchBalance", (String)"balance", (Object[])new Object[]{EBGateway.getRequest(BatchBalanceRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "balance": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"balance", (String)"balance", (Object[])new Object[]{EBGateway.getRequest(BatchBalanceRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "balanceStatement": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"balanceStatement", (String)"balanceStatement", (Object[])new Object[]{EBGateway.getRequest(BalanceStatementRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "balanceReconciliation": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"balanceReconciliation", (String)"balanceReconciliation", (Object[])new Object[]{EBGateway.getRequest(BalanceReconciliationRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "queryBalanceReconciliation": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"queryBalanceReconciliation", (String)"queryBalanceReconciliation", (Object[])new Object[]{EBGateway.getRequest(QueryBalanceReconciliationRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "updateBalanceReconciliationStatus": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"updateBalanceReconciliationStatus", (String)"updateBalanceReconciliationStatus", (Object[])new Object[]{EBGateway.getRequest(UpdateBalanceReconciliationStatusRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "detail": {
                        DetailRequest detailRequest = EBGateway.getRequest(DetailRequest.class, data, ebRequestEnhance);
                        if (detailRequest.getBody().isAsync()) {
                            ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"detailAsync", (String)"detailAsync", (Object[])new Object[]{detailRequest});
                            break;
                        }
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"detail", (String)"detail", (Object[])new Object[]{detailRequest});
                        break;
                    }
                    case "syncAccount": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"syncAccount", (String)"syncAccount", (Object[])new Object[]{EBGateway.getRequest(SyncAccountRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "ebgParam": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"ebgParam", (String)"ebgParam", (Object[])new Object[]{EBGateway.getRequest(ParamRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "listBankLogin": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"listBankLogin", (String)"listBankLogin", (Object[])new Object[]{EBGateway.getRequest(ListBankLoginRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "ping": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"ping", (String)"ping", (Object[])new Object[]{EBGateway.getRequest(MonitorRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "apply": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"apply", (String)"apply", (Object[])new Object[]{EBGateway.getRequest(ApplyRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "queryApply": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"queryApply", (String)"queryApply", (Object[])new Object[]{EBGateway.getRequest(QueryApplyRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "cert": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"cert", (String)"cert", (Object[])new Object[]{EBGateway.getRequest(CertRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "register": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"register", (String)"register", (Object[])new Object[]{EBGateway.getRequest(RegisterRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "listBank": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"listBank", (String)"listBank", (Object[])new Object[]{EBGateway.getRequest(ListBankRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "bankLoginConfig": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"bankLoginConfig", (String)"bankLoginConfig", (Object[])new Object[]{EBGateway.getRequest(BankLoginConfigRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "bankLoginDetail": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"bankLoginDetail", (String)"bankLoginDetail", (Object[])new Object[]{EBGateway.getRequest(BankLoginDetailRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "syncBankLogin": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"syncBankLogin", (String)"syncBankLogin", (Object[])new Object[]{EBGateway.getRequest(SyncBankLoginRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "pay": {
                        ebResponse = EBAsyncServiceImpl.getInstance().pay(EBGateway.getRequest(PayRequest.class, data, ebRequestEnhance));
                        break;
                    }
                    case "mockPayTest": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"mockPayTest", (String)"mockPayTest", (Object[])new Object[]{EBGateway.getRequest(PayRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "overseaPay": {
                        ebResponse = EBAsyncServiceImpl.getInstance().overseaPay(EBGateway.getRequest(OverseaPayRequest.class, data, ebRequestEnhance));
                        break;
                    }
                    case "queryPay": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"queryPay", (String)"queryPay", (Object[])new Object[]{EBGateway.getRequest(QueryPayRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "queryOverseaPay": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"queryOverseaPay", (String)"queryOverseaPay", (Object[])new Object[]{EBGateway.getRequest(QueryOverseaPayRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "linkpay": {
                        ebResponse = EBAsyncServiceImpl.getInstance().linkpay(EBGateway.getRequest(LinkPayRequest.class, data, ebRequestEnhance));
                        break;
                    }
                    case "queryLinkpay": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"queryLinkpay", (String)"queryLinkpay", (Object[])new Object[]{EBGateway.getRequest(QueryLinkPayRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "updatePayStatus": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"updatePayStatus", (String)"updatePayStatus", (Object[])new Object[]{EBGateway.getRequest(PayStatusRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "UpdateTenant": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"UpdateTenant", (String)"UpdateTenant", (Object[])new Object[]{EBGateway.getRequest(UpdateTenantRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "currentAndFixed": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"currentAndFixed", (String)"currentAndFixed", (Object[])new Object[]{EBGateway.getRequest(CurrentAndFixedRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "queryCurrentAndFixed": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"queryCurrentAndFixed", (String)"queryCurrentAndFixed", (Object[])new Object[]{EBGateway.getRequest(QueryCurAndFixedRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "updateCurAndFixedStatus": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"updateCurAndFixedStatus", (String)"updateCurAndFixedStatus", (Object[])new Object[]{EBGateway.getRequest(CafStatusRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "withdrawFromNAcc": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"withdrawFromNAcc", (String)"withdrawFromNAcc", (Object[])new Object[]{EBGateway.getRequest(kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.withdraw.CurrentAndFixedExRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "cancelNotification": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"cancelNotification", (String)"cancelNotification", (Object[])new Object[]{EBGateway.getRequest(CurrentAndFixedExRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "queryFinancing": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"queryFinancing", (String)"queryFinancing", (Object[])new Object[]{EBGateway.getRequest(QueryFinancingRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "buyFinancing": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"buyFinancing", (String)"buyFinancing", (Object[])new Object[]{EBGateway.getRequest(BuyFinancingRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "queryBuyFinancing": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"queryBuyFinancing", (String)"queryBuyFinancing", (Object[])new Object[]{EBGateway.getRequest(QueryBuyFinancingRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "redeemFinancing": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"redeemFinancing", (String)"redeemFinancing", (Object[])new Object[]{EBGateway.getRequest(RedeemFinancingRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "queryRedeemFinancing": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"queryRedeemFinancing", (String)"queryRedeemFinancing", (Object[])new Object[]{EBGateway.getRequest(QueryRedeemFinancingRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "updateFinancingStatus": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"updateFinancingStatus", (String)"updateFinancingStatus", (Object[])new Object[]{EBGateway.getRequest(FinancingStatusRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "syncMappedAcct": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"syncMappedAcct", (String)"syncMappedAcct", (Object[])new Object[]{EBGateway.getRequest(MappingAcctRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "queryCredit": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"queryCredit", (String)"queryCredit", (Object[])new Object[]{EBGateway.getRequest(QueryCreditRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "openCredit": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"openCredit", (String)"openCredit", (Object[])new Object[]{EBGateway.getRequest(OpenCreditRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "openCreditQuery": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"openCreditQuery", (String)"openCreditQuery", (Object[])new Object[]{EBGateway.getRequest(QueryOpenCreditRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "queryCreditReceived": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"queryCreditReceived", (String)"queryCreditReceived", (Object[])new Object[]{EBGateway.getRequest(QueryCreditReceivedRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    case "downloadBankFile": {
                        ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"downloadBankFile", (String)"downloadBankFile", (Object[])new Object[]{EBGateway.getRequest(DownLoadFileRequest.class, data, ebRequestEnhance)});
                        break;
                    }
                    default: {
                        boolean flag = false;
                        for (Map.Entry<String, Map<String, Class>> entry : CustomizeService.customizeMethodCache.entrySet()) {
                            if (!bizType.equalsIgnoreCase(entry.getKey())) continue;
                            flag = true;
                            ebResponse = (EBResponse)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"customize", (String)"customize", (Object[])new Object[]{EBGateway.getRequest(entry.getValue().get("requestClass"), data, ebRequestEnhance)});
                            break;
                        }
                        if (!flag) {
                            throw new EBBaseException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"EBGateway_1", (String)"ebg-aqap-mservice", (Object[])new Object[0]));
                        }
                        break;
                    }
                }
            }
            catch (Throwable e) {
                response = new EBServiceResponse();
                response.setVersion(request.getVersion());
                response.setResponseCode(EBResponseCode.BIZ_ERROR.getResponseCode());
                response.setResponseMsg(EBResponseCode.BIZ_ERROR.getResponseMessage());
                EBException ebException = new EBException();
                ebException.setMessage(e.getMessage());
                if (ebResponse == null) {
                    ebResponse = new EBResponse();
                }
                ebException.setParams(EBExceiptionUtil.stackTrace((StackTraceElement[])e.getStackTrace()));
                ebResponse.setException(ebException);
                responseData = JsonUtil.toJsonLine((Object)ebResponse);
                this.setContextResponse();
                logger.infoResponse("\u54cd\u5e94\u7ed3\u679c\uff1a\n{}", (Object)CommonUtils.prettyJson(responseData));
                response.setData(responseData);
                EBFrontUtil.encryptResponse((EBServiceRequest)request, (EBServiceResponse)response);
            }
            response = new EBServiceResponse();
            response.setVersion(request.getVersion());
            String responseCode = null;
            String responseMsg = null;
            if (Objects.isNull(ebResponse.getException())) {
                responseCode = EBResponseCode.BIZ_SUCCESS.getResponseCode();
                responseMsg = EBResponseCode.BIZ_SUCCESS.getResponseMessage();
            } else {
                EBException ebException = ebResponse.getException();
                if (ebException.getInnerException() != null) {
                    if (ebException.getInnerException().equals("preException")) {
                        responseCode = EBResponseCode.BASE_ERROR.getResponseCode();
                        responseMsg = EBResponseCode.BASE_ERROR.getResponseMessage() + "," + ebException.getMessage();
                    } else if (ebException.getInnerException().equals("serviceException")) {
                        responseCode = EBResponseCode.BIZ_ERROR.getResponseCode();
                        responseMsg = EBResponseCode.BIZ_ERROR.getResponseMessage() + "," + ebException.getMessage();
                    } else {
                        responseCode = ebResponse.getException().getErrorCode();
                        responseMsg = ebResponse.getException().getMessage();
                    }
                } else {
                    responseCode = EBResponseCode.DUBBO_ERROR.getResponseCode();
                    responseMsg = EBResponseCode.DUBBO_ERROR.getResponseMessage();
                }
            }
            response.setResponseCode(responseCode);
            response.setResponseMsg(responseMsg);
            responseData = JsonUtil.toJsonLine((Object)ebResponse);
            this.setContextResponse();
            logger.infoResponse("\u54cd\u5e94\u7ed3\u679c\uff1a\n{}", (Object)CommonUtils.prettyJson(responseData));
            response.setData(responseData);
            EBFrontUtil.encryptResponse((EBServiceRequest)request, (EBServiceResponse)response);
        }
        catch (Throwable e) {
            logger.monitorInfo(String.format(ResManager.loadKDString((String)"\u63a5\u6536\u5230\u4e1a\u52a1\u8bf7\u6c42\uff1a%s", (String)"EBGateway_2", (String)"ebg-aqap-mservice", (Object[])new Object[0]), jsonMap));
            response = new EBServiceResponse();
            response.setVersion(request.getVersion());
            response.setResponseCode(EBResponseCode.SECURITY_ERROR.getResponseCode());
            response.setResponseMsg(e.getMessage());
            EBResponse ebResponse = new EBResponse();
            EBException ebException = new EBException();
            ebException.setErrorCode(EBResponseCode.SECURITY_ERROR.getResponseCode());
            ebException.setMessage(e.getMessage());
            ebException.setParams(EBExceiptionUtil.stackTrace((StackTraceElement[])e.getStackTrace()));
            ebResponse.setException(ebException);
            responseData = JsonUtil.toJsonLine((Object)ebResponse);
            this.setContextResponse();
            logger.monitorInfo(String.format(ResManager.loadKDString((String)"\u54cd\u5e94\u4e1a\u52a1\u8bf7\u6c42\u62a5\u6587\uff1a%s", (String)"EBGateway_3", (String)"ebg-aqap-mservice", (Object[])new Object[0]), CommonUtils.prettyJson(responseData)));
            response.setData(responseData);
            EBFrontUtil.encryptResponse((EBServiceRequest)request, (EBServiceResponse)response);
        }
        boolean isIgnoreSign = Boolean.parseBoolean(System.getProperty("ignoreSign"));
        if (!isIgnoreSign) {
            EBFrontUtil.signResponse((EBServiceResponse)response, (EBBaseRequest)request);
        }
        if (response.getResponseCode().equals(EBResponseCode.BIZ_SUCCESS.getResponseCode())) {
            result.setErrorCode("success");
            result.setData((Object)response);
            result.setSuccess(true);
        } else {
            result.setErrorCode("fail");
            result.setData((Object)response);
            result.setSuccess(false);
        }
        long cost = System.currentTimeMillis() - currentMs;
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        logger.info("API\u8bf7\u6c42{},\u5904\u7406\u8017\u65f6\uff1a{}ms", new Object[]{request.getBizType(), cost});
        return result;
    }

    private void setContextResponse() {
        try {
            EBContext.getContext().setType("response");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static <T extends EBRequest> T getRequest(Class<T> requestClass, String data, EBRequestEnhance ebRequestEnhance) {
        EBRequest request = (EBRequest)JsonUtil.json2Obj((String)data, requestClass);
        request.getHeader().setCustomId(ebRequestEnhance.getCustomId());
        request.getHeader().setLogBizSeqID(ebRequestEnhance.getLogBizSeqId());
        request.getHeader().setLogRequestSeqID(ebRequestEnhance.getLogRequestSeqId());
        request.getHeader().setExtData(ebRequestEnhance.getHeader().getExtData());
        return (T)request;
    }
}

