/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.log.EBGLogger;

public class PaymentInfosUtil {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(PaymentInfosUtil.class);

    public static PaymentInfo selectPaymentInfoByBillNo(List<PaymentInfo> infos, String billNo) {
        for (int i = 0; i < infos.size(); ++i) {
            if (!infos.get(i).getBankDetailSeqId().equalsIgnoreCase(billNo)) continue;
            return infos.get(i);
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u4e5f\u8bb8\u8fd4\u56de\u4e86\u610f\u5916\u7684\u8d26\u5355\u53f7:%s\u3002", (String)"PaymentInfosUtil_4", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), billNo);
        log.error(errorMsg);
        return null;
    }

    public static PaymentInfo selectPaymentInfo(List<PaymentInfo> infos, String incomeAccNo, String incomeAccName, String amountStr) {
        BigDecimal amount = new BigDecimal(amountStr);
        BigDecimal formatedAmount = amount.setScale(2, 1);
        for (int i = 0; i < infos.size(); ++i) {
            if (!infos.get(i).getIncomeAccNo().equalsIgnoreCase(incomeAccNo) || !infos.get(i).getAmount().equals(formatedAmount) || !infos.get(i).getIncomeAccName().equalsIgnoreCase(incomeAccName)) continue;
            return infos.get(i);
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u4e5f\u8bb8\u8fd4\u56de\u4e86\u610f\u5916\u7684\u6536\u6b3e\u5e10\u53f7:%1$s\u6216\u6536\u6b3e\u6237\u540d:%2$s\u6216\u610f\u5916\u7684\u91d1\u989d:%3$s\u3002", (String)"PaymentInfosUtil_5", (String)"ebg-aqap-banks-citic-dc", (Object[])new Object[0]), incomeAccNo, incomeAccName, amount);
        log.error(errorMsg);
        return null;
    }
}

