/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.dc.services.payment.income;

import kd.ebg.aqap.banks.citic.dc.services.PayParserProxy;
import kd.ebg.aqap.banks.citic.dc.services.payment.income.IncomeQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IncomePayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IncomeQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLAGESUB";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "income".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLAGESUB");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)root, (String)"accountNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)root, (String)"payType", (String)(paymentInfo.is2SameBank() ? "01" : "02"));
        JDomUtils.addChild((Element)root, (String)"preFlg", (String)"0");
        JDomUtils.addChild((Element)root, (String)"preDate", (String)"");
        JDomUtils.addChild((Element)root, (String)"preTime", (String)"");
        JDomUtils.addChild((Element)root, (String)"memo", (String)"");
        Element list = JDomUtils.addChild((Element)root, (String)"list");
        list.setAttribute("name", "userDataList");
        for (int i = 0; i < request.getPaymentInfos().size(); ++i) {
            Element row = JDomUtils.addChild((Element)list, (String)"row");
            JDomUtils.addChild((Element)row, (String)"billNo", (String)paymentInfo.getBankDetailSeqId());
            JDomUtils.addChild((Element)row, (String)"payAccNo", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"payAccBankNm", (String)paymentInfo.getIncomeBankName());
            JDomUtils.addChild((Element)row, (String)"payAccNm", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)row, (String)"tranAmount", (String)paymentInfo.getAmount().toString());
            JDomUtils.addChild((Element)row, (String)"abstract", (String)paymentInfo.getExplanation());
        }
        String message = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PayParserProxy.parseBatchPay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

