/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jlb.cms.services.balance;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jlb.cms.services.Common;
import kd.ebg.aqap.banks.jlb.cms.services.Packer;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String getDeveloper() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]);
    }

    public String getBizCode() {
        return "200108";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u6838\u5fc3\u4f59\u989d (200108)", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]);
    }

    public String pack(BankBalanceRequest rqst) {
        BankAcnt acnt = rqst.getAcnt();
        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String tr_code = "200108";
        Element ap = Packer.createCommonHead(tr_code, req_no, "0");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)rqst.getBankCurrency());
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        xmlMsg = Common.createCommonMsg(xmlMsg);
        return xmlMsg;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0%1$s,%2$s", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        String tr_acdt = head.getChildTextTrim("tr_acdt");
        String tr_time = head.getChildTextTrim("tr_time");
        Element body = ap.getChild("body");
        String cur_code = body.getChildTextTrim("cur_code");
        String balance = body.getChildTextTrim("balance");
        String use_balance = body.getChildTextTrim("use_balance");
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(rqst.getAcnt());
        balanceInfo.setBankCurrency(cur_code);
        balanceInfo.setBalanceDateTime(LocalDateTime.parse(tr_acdt + tr_time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        if (!StringUtils.isEmpty((String)balance)) {
            balanceInfo.setCurrentBalance(new BigDecimal(balance));
        }
        if (!StringUtils.isEmpty((String)use_balance)) {
            balanceInfo.setAvailableBalance(new BigDecimal(use_balance));
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}

