/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hzyq.dc.service.payment.batchPay;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hzyq.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.HZYQ_Packer;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.TCommon;
import kd.ebg.aqap.banks.hzyq.dc.service.helper.Utils;
import kd.ebg.aqap.banks.hzyq.dc.service.payment.batchPay.CompanyBatchPayQueryImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyBatchPayImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(CompanyBatchPayImpl.class);
    private static final String tradeName = "BY0002";

    public int getBatchSize() {
        return 150;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyBatchPayQueryImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return tradeName;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u676d\u5dde\u94f6\u884c\u6279\u91cf\u8f6c\u8d26", (String)"CompanyBatchPayImpl_0", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equals(paymentInfo.getSubBizType()) && !HZYQ_Packer.isSalary(paymentInfo) && paymentInfo.getTotalCount() > 1;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = Utils.listToArray(request.getPaymentInfos());
        Element root = new Element("body");
        Element head = HZYQ_Packer.createHZYQRoot(tradeName);
        JDomUtils.addChild((Element)root, (Element)head);
        Element map = new Element("map");
        JDomUtils.addChild((Element)map, (String)"payerAccNo", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)map, (String)"payerCorpCode", (String)paymentInfos[0].getAccDept());
        JDomUtils.addChild((Element)map, (String)"payerCorpName", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)map, (String)"erpPayerCorpCode", (String)RequestContextUtils.getBankParameterValue((String)"erpPayerCorpCode"));
        JDomUtils.addChild((Element)map, (String)"erpBatchNo", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)map, (String)"erpReqUser", (String)"");
        JDomUtils.addChild((Element)map, (String)"isErpCode", (String)"0");
        JDomUtils.addChild((Element)root, (Element)map);
        Element loopData = new Element("loopData");
        JDomUtils.addChild((Element)root, (Element)loopData);
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element row = JDomUtils.addChild((Element)loopData, (String)"row");
            JDomUtils.addChild((Element)row, (String)"payeeAccNo", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"payeeAccName", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)row, (String)"payeeBankName", (String)paymentInfos[i].getIncomeBankName());
            JDomUtils.addChild((Element)row, (String)"payeeBankCode", (String)paymentInfos[i].getIncomeCnaps());
            JDomUtils.addChild((Element)row, (String)"payMoney", (String)paymentInfos[i].getAmount().toString());
            JDomUtils.addChild((Element)row, (String)"isForindividual", (String)(paymentInfos[i].is2Individual() ? "1" : "0"));
            JDomUtils.addChild((Element)row, (String)"difSign", (String)(paymentInfos[i].is2SameBank() ? "0" : "1"));
            JDomUtils.addChild((Element)row, (String)"quick", (String)"0");
            JDomUtils.addChild((Element)row, (String)"payFlow", (String)"2");
            JDomUtils.addChild((Element)row, (String)"payType", (String)"34");
            ZoneId zoneId = ZoneId.systemDefault();
            ZonedDateTime zdt = paymentInfos[i].getRequestTime().atZone(zoneId);
            JDomUtils.addChild((Element)row, (String)"wishPayDate", (String)HZYQ_Packer.formateY2SDate(Date.from(zdt.toInstant())));
            JDomUtils.addChild((Element)row, (String)"payPurpose", (String)paymentInfos[i].getUseCn());
            JDomUtils.addChild((Element)row, (String)"rmk", (String)paymentInfos[i].getExplanation());
            JDomUtils.addChild((Element)row, (String)"erpReqNo", (String)paymentInfos[i].getBankDetailSeqId());
            if (!BankBusinessConfig.isAddKDFlagToPay()) continue;
            JDomUtils.addChild((Element)map, (String)"addWord", (String)BizNoUtil.cont((String)paymentInfos[i].getBankDetailSeqId(), (String)paymentInfos[i].getExplanation()));
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos[i]);
        }
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String rspmsg = HZYQ_Packer.headnumber(tradeName) + RspMsg;
        return TCommon.createCommonMsg(rspmsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String rspStr) {
        PaymentInfo[] paymentInfos = Utils.listToArray(request.getPaymentInfos());
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element head = JDomUtils.getChildElement((Element)root, (String)"head");
        String erpSysCode = JDomUtils.getChildText((Element)head, (String)"erpSysCode");
        String custNo = JDomUtils.getChildText((Element)head, (String)"custNo");
        String tradeName = JDomUtils.getChildText((Element)head, (String)"tradeName");
        String retCode = JDomUtils.getChildText((Element)head, (String)"retCode");
        String retMsg = JDomUtils.getChildText((Element)head, (String)"retMsg");
        Element loopData = root.getChild("loopData");
        if (loopData == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u8fd4\u56de\u7684xml\u9519\u8bef\uff0cloopData\u8282\u70b9\u4e0d\u5b58\u5728\u3002", (String)"CompanyBatchPayImpl_1", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]));
        }
        List list = loopData.getChildren("row");
        if (list == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u8fd4\u56de\u7684xml\u9519\u8bef\uff0crow\u8282\u70b9\u4e0d\u5b58\u5728\u3002", (String)"CompanyBatchPayImpl_2", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]));
        }
        for (int i = 0; i < list.size(); ++i) {
            Element row = (Element)list.get(i);
            String billCode = row.getChildTextTrim("billCode");
            String string = row.getChildTextTrim("erpReqNo");
        }
        if ("0".equals(retCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"CompanyBatchPayImpl_3", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)retCode, (String)retMsg);
        } else if ("2".equals(retCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyBatchPayImpl_4", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)retCode, (String)retMsg);
        } else if ("9".equals(retCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u901a\u8baf\u8d85\u65f6\u6216\u5f02\u5e38\u3002", (String)"CompanyBatchPayImpl_5", (String)"ebg-aqap-banks-hzyq-dc", (Object[])new Object[0]), (String)retCode, (String)retMsg);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String uri = "";
        try {
            uri = RequestContextUtils.getBankParameterValue((String)"uri");
        }
        catch (Exception e) {
            log.error("\u676d\u5dde\u94f6\u4f01\u83b7\u53d6uri\u5f02\u5e38", (Throwable)e);
        }
        log.info("\u676d\u5dde\u8d22\u653f\u7cfb\u7edfURI\u8def\u5f84:{}", (Object)uri);
        factory.setUri(uri);
    }
}

