/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.tlyh.dc.services.payment.salary;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.tlyh.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.tlyh.dc.services.payment.salary.QueryPayImpl;
import kd.ebg.aqap.banks.tlyh.dc.services.utils.Helper;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = JDomUtils.createRoot((String)"reqData");
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        JDomUtils.addChild((Element)head, (String)"serviceId", (String)"batchSalaryReleaseBCDC");
        JDomUtils.addChild((Element)head, (String)"bussSeqNo", (String)"123413241");
        JDomUtils.addChild((Element)head, (String)"txSno", (String)Sequence.gen16Sequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"pyrCstmrAcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"feeAcctNm", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"payerOpenBankCode", (String)paymentInfo.getPayeeBankCode());
        JDomUtils.addChild((Element)body, (String)"ccy", (String)paymentInfo.getCurrency());
        String payDate = paymentInfo.getBookingTime() != null ? paymentInfo.getBookingTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")) : LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        PaymentUtil.setBookPayFlag((List)paymentInfos);
        JDomUtils.addChild((Element)body, (String)"payDate", (String)payDate);
        JDomUtils.addChild((Element)body, (String)"clientNo", (String)RequestContextUtils.getParameter().getBankParameter("clientNo"));
        JDomUtils.addChild((Element)body, (String)"totalAmnt", (String)this.getTotalAmount(paymentInfos));
        JDomUtils.addChild((Element)body, (String)"thirdSeqNo", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)body, (String)"aprvOprtFlg", (String)BankBusinessConfig.isSalaryApproval());
        String operationType = "0";
        if (UseConvertor.isReim((PaymentInfo)paymentInfo)) {
            operationType = "1";
        }
        JDomUtils.addChild((Element)body, (String)"operationType", (String)operationType);
        for (int i = 0; i < paymentInfos.size(); ++i) {
            Element payeeInfoArray = JDomUtils.addChild((Element)body, (String)"payeeInfoArray");
            PaymentInfo payInfo = (PaymentInfo)paymentInfos.get(i);
            JDomUtils.addChild((Element)payeeInfoArray, (String)"srlNo", (String)payInfo.getBankDetailSeqID());
            JDomUtils.addChild((Element)payeeInfoArray, (String)"pyeeCstmrAcct", (String)payInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)payeeInfoArray, (String)"payeeAcctName", (String)payInfo.getIncomeAccName());
            JDomUtils.addChild((Element)payeeInfoArray, (String)"payeeOpenBankInterbankNo", (String)payInfo.getIncomeCnaps());
            JDomUtils.addChild((Element)payeeInfoArray, (String)"thirdSeqNo", (String)"");
            JDomUtils.addChild((Element)payeeInfoArray, (String)"tranAmt", (String)payInfo.getAmount().toString());
            JDomUtils.addChild((Element)payeeInfoArray, (String)"ccy", (String)payInfo.getCurrency());
            JDomUtils.addChild((Element)payeeInfoArray, (String)"purpose", (String)payInfo.getExplanation());
        }
        return Helper.element2jsonStr(root);
    }

    private String getTotalAmount(List<PaymentInfo> paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            bigDecimal = bigDecimal.add(paymentInfos.get(i).getAmount());
        }
        return bigDecimal.toString();
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        JSONObject rspData = jsonObject.getJSONObject("rspData");
        JSONObject head = rspData.getJSONObject("head");
        String errorCode = head.getString("errorCode");
        String errorMsg = head.getString("errorMsg");
        BankResponse bankResponse = new BankResponse();
        bankResponse.setResponseCode(errorCode);
        bankResponse.setResponseMessage(errorMsg);
        if (!"000000".equalsIgnoreCase(errorCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u4ee3\u7801\u3002", (String)"PayImpl_0", (String)"ebg-aqap-banks-tlyh-dc", (Object[])new Object[0]), (String)errorCode, (String)errorMsg);
            return new EBBankPayResponse(paymentInfos);
        }
        JSONObject body = rspData.getJSONObject("body");
        String orderStatus = body.getString("orderStatus");
        if ("3".equals(orderStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayImpl_3", (String)"ebg-aqap-banks-tlyh-dc", (Object[])new Object[0]), (String)orderStatus, (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"PayImpl_5", (String)"ebg-aqap-banks-tlyh-dc", (Object[])new Object[0]));
        } else if ("4".equals(orderStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayImpl_3", (String)"ebg-aqap-banks-tlyh-dc", (Object[])new Object[0]), (String)orderStatus, (String)ResManager.loadKDString((String)"\u7b49\u5f85\u5ba1\u6279", (String)"PayImpl_6", (String)"ebg-aqap-banks-tlyh-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PayImpl_7", (String)"ebg-aqap-banks-tlyh-dc", (Object[])new Object[0]), (String)orderStatus, (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/preSfpPOST");
        factory.setHttpHeader("Content-Type", "application/json");
    }
}

