/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zzb.dc.services.payment.same;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Packer;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SameBankQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final String TRANCODE = "SingleTrsJnlsQryB2E";

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)ZZB_Packer.buildHead(TRANCODE, paymentInfo.getBankBatchSeqId()));
        Element body = new Element("Body");
        JDomUtils.addChild((Element)body, (String)"TrsType", (String)"1");
        JDomUtils.addChild((Element)body, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
        String mode = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
        String time = "";
        time = !StringUtils.isEmpty((String)mode) && mode.length() == 8 ? mode : paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)time);
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)time);
        JDomUtils.addChild((Element)body, (String)"ErpJnlNo", (String)paymentInfo.getBankBatchSeqId());
        ZZB_Packer.checkSynNo(PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"McJnlno"));
        JDomUtils.addChild((Element)body, (String)"JnlNo", (String)PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"McJnlno"));
        JDomUtils.addChild((Element)body, (String)"BeginCount", (String)"1");
        JDomUtils.addChild((Element)body, (String)"QueryCount", (String)"1");
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)ebank_root, (String)encoding);
        return requestMessage;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element body = bank_root.getChild("Body");
        BankResponse headRsp = ZZB_Parser.parserCommonInfo(bank_root);
        String bankStatus = headRsp.getResponseCode();
        if (!"000000".equals(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"SameBankQueryPayImpl_7", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), headRsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element list = body.getChild("List");
        List lists = list.getChildren("Map");
        if (lists.size() == 0) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u6d4b\u8bd5\u73af\u5883\u65f6\u95f4\u95ee\u9898%s\u3002", (String)"SameBankQueryPayImpl_8", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), headRsp.getResponseMessage()));
        } else {
            for (Element element : lists) {
                String amount = element.getChildText("TrsAmount");
                if (StringUtils.isEmpty((String)amount)) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u62a5\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"SameBankQueryPayImpl_3", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]));
                }
                String accNo = element.getChildText("PayeeAcNo");
                PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)accNo, (BigDecimal)new BigDecimal(amount));
                if (paymentInfo == null) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6839\u636e\u8fd4\u56de\u62a5\u6587\u7684\u6536\u6b3e\u5e10\u53f7\u548c\u91d1\u989d\u627e\u4e0d\u5230\u76f8\u5e94\u7684\u4ed8\u6b3e\u8bb0\u5f55\u3002", (String)"SameBankQueryPayImpl_4", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]));
                }
                String returnCode = JDomUtils.getChildText((Element)element, (String)"ProcessState");
                if ("OK".equals(returnCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SameBankQueryPayImpl_5", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]));
                    continue;
                }
                if ("FL".equals(returnCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
                    continue;
                }
                if ("UC".equals(returnCode) || "BH".equalsIgnoreCase(returnCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankStatus, (String)headRsp.getResponseMessage());
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return TRANCODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u884c\u8f6c\u8d26\u67e5\u8be2", (String)"SameBankQueryPayImpl_6", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eb2e/SingleTrsJnlsQryB2E.do?";
        s = s + "userPassword=" + RequestContextUtils.getBankParameterValue((String)"userPassword") + "&SIGDATA=0&_locale=zh_CN";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
    }
}

