/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.balance;

import com.icbc.api.response.MybankEnterpriseAccountMeahisbalqryResponseV1;
import com.icbc.api.response.MybankEnterpriseAccountQaccbalResponseV1;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.opa.BankBusinessConfig;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class BalanceParser {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceParser.class);

    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, MybankEnterpriseAccountQaccbalResponseV1 response) {
        if (response.isSuccess()) {
            List responseRds = response.getRd();
            MybankEnterpriseAccountQaccbalResponseV1.MybankEnterpriseAccountQaccbalResponseV1Rd rd = (MybankEnterpriseAccountQaccbalResponseV1.MybankEnterpriseAccountQaccbalResponseV1Rd)responseRds.get(0);
            int code = rd.getiRetCode();
            String msg = rd.getiRetMsg();
            if (!"0".equals(code + "")) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 \u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%2$s\u3002", (String)"BalanceParser_5", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]), code, msg));
            }
            BalanceInfo info = new BalanceInfo();
            info.setBankCurrency(rd.getCurrency());
            BigDecimal current = rd.getBalance();
            this.logger.info("\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\uff1a" + current);
            BigDecimal avaible = rd.getUsableBalance();
            this.logger.info("\u8fd4\u56de\u7684\u53ef\u7528\u4f59\u989d\u4e3a\uff1a" + avaible);
            info.setCurrentBalance(BigDecimalHelper.div((BigDecimal)current, (BigDecimal)new BigDecimal("100.00")));
            info.setAvailableBalance(BigDecimalHelper.div((BigDecimal)avaible, (BigDecimal)new BigDecimal("100.00")));
            info.setBalanceDateTime(LocalDateTime.now());
            info.setBankAcnt(rqst.getAcnt());
            ArrayList<BalanceInfo> result = new ArrayList<BalanceInfo>(16);
            result.add(info);
            return new EBBankBalanceResponse(result);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 \u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s\u3002", (String)"BalanceParser_6", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]), response.getReturnMsg(), response.getReturnCode(), response.getReturnMsg()));
    }

    public EBBankBalanceResponse parseHisBalanceBalance(BankBalanceRequest rqst, MybankEnterpriseAccountMeahisbalqryResponseV1 response) {
        if (response.isSuccess()) {
            List responseRds = response.getRd();
            BalanceInfo[] balances = new BalanceInfo[responseRds.size()];
            for (int i = 0; i < responseRds.size(); ++i) {
                Long amount = ((MybankEnterpriseAccountMeahisbalqryResponseV1.MybankEnterpriseAccountMeahisbalqryResponseRdV1)responseRds.get(i)).getAmount();
                balances[i] = new BalanceInfo();
                balances[i].setBankAcnt(rqst.getAcnt());
                balances[i].setBankCurrency(rqst.getBankCurrency());
                String transDate = ((MybankEnterpriseAccountMeahisbalqryResponseV1.MybankEnterpriseAccountMeahisbalqryResponseRdV1)responseRds.get(i)).getDate();
                balances[i].setBalanceDateTime(LocalDateTime.parse(transDate + "000000", DateTimeFormatter.ofPattern("yyyy-MM-ddHHmmss")));
                balances[i].setCurrentBalance(BigDecimalHelper.div((BigDecimal)new BigDecimal(amount), (BigDecimal)new BigDecimal("100.00")));
                if (!BankBusinessConfig.isCashPool(rqst.getAcnt().getAccNo())) continue;
                Long avail = ((MybankEnterpriseAccountMeahisbalqryResponseV1.MybankEnterpriseAccountMeahisbalqryResponseRdV1)responseRds.get(i)).getPoolAmt();
                balances[i].setAvailableBalance(BigDecimalHelper.div((BigDecimal)new BigDecimal(avail), (BigDecimal)new BigDecimal("100.00")));
            }
            return new EBBankBalanceResponse(Arrays.asList(balances));
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 \u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s\u3002", (String)"BalanceParser_6", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]), response.getReturnMsg(), response.getReturnCode(), response.getReturnMsg()));
    }
}

