/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.balancereconciliation;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseReconctilationYdzsubbdzRequestV1;
import com.icbc.api.response.MybankEnterpriseReconctilationYdzsubbdzResponseV1;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.opa.service.util.GetStore;
import kd.ebg.aqap.banks.icbc.opa.service.util.TestDateUtil;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceReconciliationImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceReconciliation;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceReconciliationRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceReconciliationResponse;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import net.sf.json.JSONObject;

public class BalanceReconciliationImpl
extends AbstractBalanceReconciliationImpl
implements IBalanceReconciliation {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceReconciliationImpl.class);

    public EBBankBalanceReconciliationResponse doBiz(BankBalanceReconciliationRequest request) {
        String BASE_URL = GetStore.getBaseUrl();
        String URI = "mybank/enterprise/reconctilation/ydzsubbdz/V1";
        DefaultIcbcClient client = GetStore.getClient();
        try {
            MybankEnterpriseReconctilationYdzsubbdzRequestV1.MybankEnterpriseReconctilationYdzsubbdzRequestBizV1 bizContent = new MybankEnterpriseReconctilationYdzsubbdzRequestV1.MybankEnterpriseReconctilationYdzsubbdzRequestBizV1();
            MybankEnterpriseReconctilationYdzsubbdzRequestV1 icbcRequest = new MybankEnterpriseReconctilationYdzsubbdzRequestV1();
            Date date = new Date();
            bizContent.setTransCode("YDZSUBBDZ");
            bizContent.setTranDate(TestDateUtil.getDate());
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(Sequence.gen18Sequence());
            BalanceReconciliationDetail detail = request.getDetail();
            bizContent.setAccNo(detail.getAccNo());
            bizContent.setDzdNo(detail.getStatementNo());
            String dzFlag = "0";
            if (StringUtils.equalsIgnoreCase((String)"Y", (String)detail.getCheckStatus())) {
                dzFlag = "1";
            } else if (StringUtils.equalsIgnoreCase((String)"N", (String)detail.getCheckStatus())) {
                dzFlag = "2";
            }
            bizContent.setDzFlag(dzFlag);
            bizContent.setCurrType(detail.getCurrency());
            icbcRequest.setServiceUrl(BASE_URL + "/" + URI);
            icbcRequest.setBizContent((BizContent)bizContent);
            this.logger.info("\u4f59\u989d\u5bf9\u8d26\u53cd\u9988\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)icbcRequest).toString());
            MybankEnterpriseReconctilationYdzsubbdzResponseV1 response = (MybankEnterpriseReconctilationYdzsubbdzResponseV1)client.execute((IcbcRequest)icbcRequest);
            if (response.isSuccess()) {
                String result = response.getResult();
                if ("0".equalsIgnoreCase(result)) {
                    ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.SUCCESS, (String)result, (String)ResManager.loadKDString((String)"\u5bf9\u8d26\u5b8c\u6210", (String)"BalanceReconciliationImpl_0", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
                } else {
                    ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.FAIL, (String)result, (String)"");
                }
                return new EBBankBalanceReconciliationResponse(detail);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 \u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s\u3002", (String)"BalanceParser_6", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]), response.getReturnMsg(), response.getReturnCode(), response.getReturnMsg()));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankBalanceReconciliationRequest bankBalanceReconciliationRequest) {
        return null;
    }

    public EBBankBalanceReconciliationResponse parse(BankBalanceReconciliationRequest bankBalanceReconciliationRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "YDZSUBBDZ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u7ed3\u679c\u786e\u8ba4\u63d0\u4ea4\u63a5\u53e3\u3002", (String)"BalanceReconciliationImpl_1", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceReconciliationRequest bankBalanceReconciliationRequest) {
        return true;
    }
}

