/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.payment.company;

import com.icbc.api.request.MybankEnterprisePayPayentRequestV2;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.opa.service.util.PackerUtils;
import kd.ebg.aqap.banks.icbc.opa.service.util.TestDateUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

class PayPacker {
    PayPacker() {
    }

    public static MybankEnterprisePayPayentRequestV2.MybankEnterprisePayPayentRequestBizV2 packer(PaymentInfo[] paymentInfos) {
        MybankEnterprisePayPayentRequestV2.MybankEnterprisePayPayentRequestBizV2 bizContent = new MybankEnterprisePayPayentRequestV2.MybankEnterprisePayPayentRequestBizV2();
        Date date = new Date();
        bizContent.setTransCode("PAYENT");
        bizContent.setTranDate(TestDateUtil.getDate());
        bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
        bizContent.setfSeqNo(paymentInfos[0].getBankBatchSeqId());
        if (paymentInfos[0].is2Merge()) {
            bizContent.setSettleMode("2");
        } else {
            bizContent.setSettleMode("0");
        }
        bizContent.setInstrCount(Integer.valueOf(paymentInfos.length));
        bizContent.setTotalAmount(PackerUtils.getTotalAmountLong(paymentInfos));
        ArrayList<MybankEnterprisePayPayentRequestV2.MybankEnterprisePayPayentRequestRdV2> rds = new ArrayList<MybankEnterprisePayPayentRequestV2.MybankEnterprisePayPayentRequestRdV2>(16);
        for (int i = 0; i < paymentInfos.length; ++i) {
            MybankEnterprisePayPayentRequestV2.MybankEnterprisePayPayentRequestRdV2 rd = new MybankEnterprisePayPayentRequestV2.MybankEnterprisePayPayentRequestRdV2();
            rd.setUniBusiId(paymentInfos[i].getBankDetailSeqId());
            rd.setiSeqNo(paymentInfos[i].getBankSerialNo());
            rd.setPayType(paymentInfos[i].is2Urgent() ? "1" : "2");
            rd.setPayerAccount(paymentInfos[i].getAccNo());
            rd.setPayeeAccount(paymentInfos[i].getAccNo());
            rd.setPayeeCnname(paymentInfos[i].getAccName());
            rd.setPayeeAccount(paymentInfos[i].getIncomeAccNo());
            rd.setPayeeCnname(paymentInfos[i].getIncomeAccName());
            rd.setIoFlag(paymentInfos[i].is2SameBank() ? "1" : "2");
            if (!paymentInfos[i].is2SameBank()) {
                rd.setPayeeBankNo(paymentInfos[i].getIncomeCnaps());
                rd.setPayeeBankName(paymentInfos[i].getIncomeBankName());
            }
            rd.setCurrency(paymentInfos[i].getCurrency());
            rd.setAmount(Long.valueOf(PackerUtils.getAmount(paymentInfos[i]).longValue()));
            rd.setPurpose(ResManager.loadKDString((String)"\u8f6c\u8d26", (String)"PayPacker_0", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
            if (paymentInfos[0].getMerge().booleanValue()) {
                rd.setRefNo(BizNoUtil.prefix_cont((String)paymentInfos[i].getBankBatchSeqId()));
                paymentInfos[i].setKdFlagID(paymentInfos[i].getBankBatchSeqId());
            } else {
                rd.setRefNo(BizNoUtil.prefix_cont((String)paymentInfos[i].getBankDetailSeqId()));
                paymentInfos[i].setKdFlagID(paymentInfos[i].getBankDetailSeqId());
            }
            String summary = paymentInfos[i].getExplanation();
            if (!StringUtils.isEmpty((String)summary) && summary.length() > 20) {
                summary = summary.substring(0, 20);
            }
            rd.setSummary(summary);
            PackerUtils.optimize(rd);
            rds.add(rd);
        }
        bizContent.setRd(rds);
        return bizContent;
    }
}

