/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jsb.cmp.service.payment.otherbank;

import java.io.InputStream;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jsb.cmp.service.payment.otherbank.OtherBankQueryPayImpl;
import kd.ebg.aqap.banks.jsb.cmp.service.util.Packer;
import kd.ebg.aqap.banks.jsb.cmp.service.util.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OtherBankPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return OtherBankQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "03020104B0211";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u8f6c\u8d26", (String)"OtherBankPayImpl_0", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        if ("pay_for_salary".equals(paymentInfo.getSubBizType())) {
            return false;
        }
        return !paymentInfo.is2SameBank();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8de8\u884c\u8f6c\u8d26\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"OtherBankPayImpl_1", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = Packer.buildHead("00003020104B0211", paymentInfos[0].getBankBatchSeqId());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"bankFlag", (String)(paymentInfo.is2SameBank() ? "1" : "2"));
        JDomUtils.addChild((Element)body, (String)"urgentFlag", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)body, (String)"rcvBankNo", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"rcvBankName", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)body, (String)"currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"payAcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"payAcctName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"amt", (String)paymentInfos[0].getAmount().toPlainString());
        JDomUtils.addChild((Element)body, (String)"rcvAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcvAcctName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"tfrType", (String)"1");
        JDomUtils.addChild((Element)body, (String)"summary", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)paymentInfo.getExplanation());
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if ("0_0000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u884c\u6210\u529f", (String)"OtherBankPayImpl_2", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"OtherBankPayImpl_3", (String)"ebg-aqap-banks-jsb-cmp", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }
}

