/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.hkn.services.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import java.util.Iterator;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dbs.hkn.services.utils.GetKeyStoreHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.Streams;

public class PgpHelper {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(PgpHelper.class);
    private static BouncyCastleProvider bouncyCastleProvider = null;
    private static PgpHelper instance;

    public static synchronized BouncyCastleProvider getProviderInstance() {
        if (bouncyCastleProvider == null) {
            bouncyCastleProvider = new BouncyCastleProvider();
        }
        return bouncyCastleProvider;
    }

    private PgpHelper() {
    }

    public static synchronized PgpHelper getInstance() {
        if (instance == null) {
            instance = new PgpHelper();
        }
        return instance;
    }

    public static String encry(String fileContent) throws Exception {
        logger.info("\u8bf7\u6c42\u539f\u6587\uff1a" + fileContent);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(fileContent.getBytes(RequestContextUtils.getCharset()));
        PgpHelper pgp = PgpHelper.getInstance();
        PGPSecretKey secretKey = pgp.readSecretKey(IOUtils.toInputStream((String)GetKeyStoreHelper.getPgpPrivateKey()));
        PGPPrivateKey prKey = pgp.findSecretKey(secretKey, RequestContextUtils.getBankParameterValue((String)"customPgpPriKeyPd").toCharArray());
        PGPPublicKey puKey = pgp.readPublicKey(IOUtils.toInputStream((String)GetKeyStoreHelper.getPgpPublicKey()));
        pgp.encryptAndSign(out, in, puKey, prKey);
        String encode = out.toString(RequestContextUtils.getCharset());
        logger.info("\u53d1\u9001\u94f6\u884c:" + encode);
        return encode;
    }

    public static String decry(String fileContent) throws Exception {
        int index;
        logger.info("\u8fd4\u56de\u62a5\u6587\uff1a" + fileContent);
        StringBuilder builder = new StringBuilder(fileContent);
        int index1 = builder.indexOf("BCPG v1.60");
        int index2 = builder.indexOf("BCPG v1.66");
        int index3 = builder.indexOf("BCPG v1.71");
        int n = index = index1 == -1 ? index2 : index1;
        if (index == -1) {
            index = index3;
        }
        if (index == -1) {
            throw new Exception(ResManager.loadKDString((String)"\u8fd4\u56dePGP\u62a5\u6587\u7248\u672c\u53f7\u9519\u8bef\uff0cBCPG\u7248\u672c\u4e0d\u662fv1.66\u6216v1.60\u6216v1.71\u3002", (String)"PgpHelper_0", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]));
        }
        builder.insert(index + 10, "\n\n");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(builder.toString().getBytes(RequestContextUtils.getCharset()));
        InputStream keyIn = IOUtils.toInputStream((String)GetKeyStoreHelper.getPgpPrivateKey());
        char[] password = RequestContextUtils.getBankParameterValue((String)"customPgpPriKeyPd").toCharArray();
        PgpHelper pgp = PgpHelper.getInstance();
        pgp.decryptStream(in, out, keyIn, null, password);
        String origin = out.toString(RequestContextUtils.getCharset());
        logger.info("\u89e3\u5bc6\u9a8c\u7b7e\u540e\u7684\u539f\u6587:" + origin);
        return origin;
    }

    public PGPPublicKey readPublicKey(InputStream in) throws IOException, PGPException {
        try (InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)in);){
            PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(decoderStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PGPPublicKey key = null;
            Iterator rIt = pgpPub.getKeyRings();
            while (key == null && rIt.hasNext()) {
                PGPPublicKeyRing kRing = (PGPPublicKeyRing)rIt.next();
                Iterator kIt = kRing.getPublicKeys();
                while (kIt.hasNext()) {
                    PGPPublicKey k = (PGPPublicKey)kIt.next();
                    System.out.println("Is Encryption Key =" + k.isEncryptionKey());
                    System.out.println("Is Master Key =" + k.isMasterKey());
                    System.out.println("Is Revoked Key =" + k.isRevoked());
                    System.out.println(" Key ID =" + k.getKeyID());
                    System.out.println(" Key Strength =" + k.getBitStrength());
                    if (!k.isEncryptionKey()) continue;
                    key = k;
                }
            }
            if (key == null) {
                throw new IllegalArgumentException("Can't find encryption key in key ring.");
            }
            PGPPublicKey pGPPublicKey = key;
            return pGPPublicKey;
        }
    }

    public boolean verifySignature(InputStream data, byte[] b, PGPPublicKey key) throws GeneralSecurityException, IOException, PGPException {
        PGPObjectFactory pgpFact = new PGPObjectFactory(b, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPSignatureList p3 = null;
        Object o = pgpFact.nextObject();
        if (o instanceof PGPCompressedData) {
            PGPCompressedData c1 = (PGPCompressedData)o;
            try (InputStream dataStream = c1.getDataStream();){
                pgpFact = new PGPObjectFactory(dataStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                p3 = (PGPSignatureList)pgpFact.nextObject();
            }
        } else {
            p3 = (PGPSignatureList)o;
        }
        if (p3 != null) {
            PGPSignature sig = p3.get(0);
            sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider((Provider)PgpHelper.getProviderInstance()), key);
            sig.update(IOUtils.toByteArray((InputStream)data));
            data.close();
            return sig.verify();
        }
        return false;
    }

    public byte[] createSignature(InputStream fIn, PGPPrivateKey keyIn, boolean armor) throws GeneralSecurityException, IOException, PGPException {
        PGPSignatureGenerator sGen = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(keyIn.getPublicKeyPacket().getAlgorithm(), 10).setProvider((Provider)PgpHelper.getProviderInstance()));
        sGen.init(0, keyIn);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ArmoredOutputStream aOut = new ArmoredOutputStream((OutputStream)byteOut);
        sGen.update(IOUtils.toByteArray((InputStream)fIn));
        aOut.endClearText();
        fIn.close();
        BCPGOutputStream bOut = new BCPGOutputStream((OutputStream)byteOut);
        sGen.generate().encode((OutputStream)bOut);
        if (armor) {
            aOut.close();
        }
        return byteOut.toByteArray();
    }

    public PGPPrivateKey findSecretKey(PGPSecretKey pgpSecKey, char[] pass) throws IOException, PGPException, NoSuchProviderException {
        return pgpSecKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider((Provider)PgpHelper.getProviderInstance()).build(pass));
    }

    static PGPPrivateKey findSecretKey(PGPSecretKeyRingCollection pgpSec, long keyID, char[] pass) throws PGPException, NoSuchProviderException {
        PGPSecretKey pgpSecKey = pgpSec.getSecretKey(keyID);
        if (pgpSecKey == null) {
            return null;
        }
        return pgpSecKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider((Provider)PgpHelper.getProviderInstance()).build(pass));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PGPSecretKey readSecretKey(InputStream input) throws IOException, PGPException {
        try (InputStream ds = PGPUtil.getDecoderStream((InputStream)input);){
            PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(ds, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            Iterator keyRingIter = pgpSec.getKeyRings();
            block10: while (true) {
                if (!keyRingIter.hasNext()) throw new IllegalArgumentException("Can't find signing key in key ring.");
                PGPSecretKeyRing keyRing = (PGPSecretKeyRing)keyRingIter.next();
                Iterator keyIter = keyRing.getSecretKeys();
                while (true) {
                    if (!keyIter.hasNext()) continue block10;
                    PGPSecretKey key = (PGPSecretKey)keyIter.next();
                    if (key.isSigningKey()) {
                        PGPSecretKey pGPSecretKey = key;
                        return pGPSecretKey;
                    }
                    continue;
                    break;
                }
                break;
            }
        }
    }

    public void decryptStream(InputStream in, OutputStream out, InputStream keyIn, PGPPublicKey publicKeyIn, char[] password) throws Exception {
        Security.addProvider((Provider)PgpHelper.getProviderInstance());
        try (InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)in);){
            PGPObjectFactory pgpF = new PGPObjectFactory(decoderStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            Object o = pgpF.nextObject();
            PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
            Iterator it = enc.getEncryptedDataObjects();
            PGPPublicKeyEncryptedData pbe = null;
            try (InputStream keyStream = PGPUtil.getDecoderStream((InputStream)keyIn);){
                PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(keyStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                PGPPrivateKey sKey = null;
                while (sKey == null && it.hasNext()) {
                    pbe = (PGPPublicKeyEncryptedData)it.next();
                    sKey = PgpHelper.findSecretKey(pgpSec, pbe.getKeyID(), password);
                }
                PublicKeyDataDecryptorFactory b = new JcePublicKeyDataDecryptorFactoryBuilder().setProvider((Provider)PgpHelper.getProviderInstance()).setContentProvider((Provider)PgpHelper.getProviderInstance()).build(sKey);
                if (pbe == null) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672a\u8bfb\u53d6\u5230pgp\u52a0\u5bc6\u6570\u636e", (String)"PgpHelper_1", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]));
                }
                try (InputStream clear = pbe.getDataStream(b);){
                    PGPObjectFactory plainFact = new PGPObjectFactory(clear, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                    Object message = plainFact.nextObject();
                    ByteArrayOutputStream actualOutput = new ByteArrayOutputStream();
                    while (message != null) {
                        if (message instanceof PGPCompressedData) {
                            PGPCompressedData compressedData = (PGPCompressedData)message;
                            plainFact = new PGPObjectFactory(compressedData.getDataStream(), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                            message = plainFact.nextObject();
                        }
                        if (message instanceof PGPLiteralData) {
                            Streams.pipeAll((InputStream)((PGPLiteralData)message).getInputStream(), (OutputStream)actualOutput);
                        } else if (!(message instanceof PGPOnePassSignatureList) && !(message instanceof PGPSignatureList)) {
                            throw new PGPException("message unknown message type.");
                        }
                        message = plainFact.nextObject();
                    }
                    actualOutput.close();
                    byte[] output = actualOutput.toByteArray();
                    out.write(output);
                }
                out.flush();
                out.close();
            }
        }
    }

    public void encryptStream(OutputStream out, InputStream inputStream, PGPPublicKey encKey, boolean armor, boolean withIntegrityCheck) throws IOException, NoSuchProviderException, PGPException {
        Security.addProvider((Provider)PgpHelper.getProviderInstance());
        OutputStream opOut = out;
        if (armor) {
            opOut = new ArmoredOutputStream(out);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PGPCompressedDataGenerator comData = new PGPCompressedDataGenerator(1);
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        OutputStream pOut = lData.open(comData.open((OutputStream)bOut), 'b', "_CONSOLE", (long)inputStream.available(), new Date());
        Streams.pipeAll((InputStream)inputStream, (OutputStream)pOut);
        comData.close();
        pOut.close();
        JcePGPDataEncryptorBuilder c = new JcePGPDataEncryptorBuilder(6).setWithIntegrityPacket(withIntegrityCheck).setSecureRandom(new SecureRandom()).setProvider((Provider)PgpHelper.getProviderInstance());
        PGPEncryptedDataGenerator cPk = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)c);
        JcePublicKeyKeyEncryptionMethodGenerator d = new JcePublicKeyKeyEncryptionMethodGenerator(encKey).setProvider((Provider)PgpHelper.getProviderInstance()).setSecureRandom(new SecureRandom());
        cPk.addMethod((PGPKeyEncryptionMethodGenerator)d);
        byte[] bytes = bOut.toByteArray();
        OutputStream cOut = cPk.open(opOut, (long)bytes.length);
        cOut.write(bytes);
        cOut.close();
        opOut.close();
    }

    public void encryptAndSign(OutputStream out, InputStream inputStream, PGPPublicKey encKey, PGPPrivateKey privateKey) throws IOException, NoSuchProviderException {
        out = new ArmoredOutputStream(out);
        try {
            PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new JcePGPDataEncryptorBuilder(9).setWithIntegrityPacket(true).setSecureRandom(new SecureRandom()).setProvider((Provider)PgpHelper.getProviderInstance()));
            encGen.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(encKey).setProvider((Provider)PgpHelper.getProviderInstance()));
            OutputStream encryptedOut = encGen.open(out, new byte[inputStream.available()]);
            PGPCompressedDataGenerator comData = new PGPCompressedDataGenerator(1);
            OutputStream compressedData = comData.open(encryptedOut);
            PGPSignatureGenerator sGen = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(privateKey.getPublicKeyPacket().getAlgorithm(), 10).setProvider((Provider)PgpHelper.getProviderInstance()));
            sGen.init(0, privateKey);
            Iterator it = encKey.getUserIDs();
            if (it.hasNext()) {
                PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
                spGen.setSignerUserID(false, (String)it.next());
                sGen.setHashedSubpackets(spGen.generate());
            }
            sGen.generateOnePassVersion(false).encode(compressedData);
            PGPLiteralDataGenerator lGen = new PGPLiteralDataGenerator();
            OutputStream lOut = lGen.open(compressedData, 'b', "Sample-Data", new Date(), new byte[inputStream.available()]);
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            lOut.write(data);
            sGen.update(data);
            lOut.close();
            lGen.close();
            sGen.generate().encode(compressedData);
            comData.close();
            compressedData.close();
            encryptedOut.close();
            encGen.close();
            out.close();
        }
        catch (PGPException e) {
            logger.error("pgp\u5f02\u5e38:", e.getCause());
        }
        catch (Exception e) {
            logger.error("pgp\u7b7e\u540d\u52a0\u5bc6\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
        }
    }
}

