/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.banklogin;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.plugin.baseplugin.CompareEnum;
import kd.ebg.aqap.formplugin.plugin.util.ShowPageUtil;
import kd.ebg.aqap.formplugin.pojo.bizinfo.BankVersionInfo;
import kd.ebg.aqap.formplugin.service.info.InfoService;
import kd.ebg.aqap.formplugin.util.CosmicDateUtil;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.monitor.LoginBusyMonitorInfo;
import kd.ebg.egf.common.model.monitor.LoginMonitorStatisticInfo;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.repository.monitor.BankReqRecordRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class BankLoginBusyMonitor
extends AbstractListPlugin {
    private BankReqRecordRepository bankReqRecordRepository = (BankReqRecordRepository)SpringContextUtil.getBean(BankReqRecordRepository.class);
    private BankLoginRepository bankLoginRepository = (BankLoginRepository)SpringContextUtil.getBean(BankLoginRepository.class);
    private FilterContainerInitArgs initArgs;
    public static final String INIT_CACHE_KEY = "initCacheKey";
    private static final String ENTITY_KEY_BANK_LOGIN = "aqap_bank_login";
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);
    private LinkedList<QFilter> rowQFilter = new LinkedList();

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        this.rowQFilter.clear();
        if (CollectionUtil.isNotEmpty((Collection)qFilters)) {
            for (QFilter qFilter : qFilters) {
                if ("bd_bank_login.id".equalsIgnoreCase(qFilter.getProperty()) || "bd_bank_version.id".equalsIgnoreCase(qFilter.getProperty()) || "query_date".equalsIgnoreCase(qFilter.getProperty())) continue;
                this.rowQFilter.add(qFilter);
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        ListView view = (ListView)this.getView();
        ControlFilters controlFilters = view.getControlFilters();
        List bankVersionIds = controlFilters.getFilter("bd_bank_version.id");
        if ("bd_bank_login.id".equalsIgnoreCase(fieldName)) {
            args.getQfilters().clear();
            if (bankVersionIds.size() > 0 && !"".equals(bankVersionIds.get(0))) {
                args.getQfilters().add(QFilter.of((String)"group.id=? and enable=?", (Object[])new Object[]{Long.parseLong(String.valueOf(bankVersionIds.get(0))), "1"}));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("btn_chart".equals(formOperate.getOperateKey())) {
            if (StringUtil.isNil(this.getPageCache().get("selectedBankLoginId")) || StringUtil.isNil(this.getPageCache().get("startDateTime")) || StringUtil.isNil(this.getPageCache().get("endDateTime"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u524d\u7f6e\u673a\u548c\u76d1\u63a7\u65e5\u671f\u3002", (String)"BankLoginBusyMonitor_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> customParams = new HashMap<String, Object>(16);
            String bankLoginID = this.getPageCache().get("selectedBankLoginId");
            String customID = RequestContext.get().getTenantId();
            String bankLoginName = this.bankLoginRepository.findByFId(bankLoginID, customID).getBankLoginName();
            customParams.put("bankLoginName", bankLoginName);
            customParams.put("startDateTime", this.getPageCache().get("startDateTime"));
            customParams.put("endDateTime", this.getPageCache().get("endDateTime"));
            ShowPageUtil.showFormPage("login_busy_monitor_chart", customParams, this.getView());
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Date s;
        String bankLoginId;
        String bankVersionId = String.valueOf(args.getFilterValue("bd_bank_version.id"));
        if ("null".equalsIgnoreCase(bankVersionId)) {
            bankVersionId = "";
        }
        if ("null".equalsIgnoreCase(bankLoginId = String.valueOf(args.getFilterValue("bd_bank_login.id")))) {
            bankLoginId = "";
        }
        String startDateTime = "";
        String endDateTime = "";
        Object object = args.getFilterValue("query_date");
        if (object instanceof List) {
            List list = (List)object;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                if (list.size() == 2) {
                    startDateTime = CosmicDateUtil.timeTranslate(sdf.parse((String)list.get(0) + " 00:00:00"));
                    endDateTime = CosmicDateUtil.timeTranslate(sdf.parse((String)list.get(1) + " 23:59:59"));
                } else if (list.size() == 1) {
                    startDateTime = CosmicDateUtil.timeTranslate(sdf.parse(CompareEnum.getCompareEnumByID((String)list.get(0)).getStartDate()));
                    endDateTime = CosmicDateUtil.timeTranslateBeforeMinute(sdf.parse(CompareEnum.getCompareEnumByID((String)list.get(0)).getEndDate()));
                }
            }
            catch (ParseException e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\u3002", (String)"BankLoginBusyMonitor_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), (Throwable)e);
            }
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            s = sf.parse(startDateTime);
            Date e = sf.parse(endDateTime);
        }
        catch (Exception ex) {
            s = new Date();
            Date e = new Date();
        }
        boolean isBankVersionChanaged = !bankVersionId.equals(this.getPageCache().get("selectedBankId")) && (!"".equals(bankVersionId) || this.getPageCache().get("selectedBankId") != null);
        boolean isBankLoginChanaged = !bankLoginId.equals(this.getPageCache().get("selectedBankLoginId")) && (!"".equals(bankLoginId) || this.getPageCache().get("selectedBankLoginId") != null);
        this.getPageCache().put("selectedBankId", bankVersionId);
        this.getPageCache().put("selectedBankLoginId", bankLoginId);
        this.getPageCache().put("isBankVersionChanaged", isBankVersionChanaged + "");
        this.getPageCache().put("startDateTime", startDateTime);
        this.getPageCache().put("endDateTime", endDateTime);
        this.getPageCache().put("SearchCondition", "yes");
        this.filterContainerInit(this.initArgs);
        this.cacheCommonFilter(args.getSearchClickEvent(), isBankVersionChanaged, isBankLoginChanaged);
    }

    private void cacheCommonFilter(SearchClickEvent searchClickEvent, boolean isBankVersionChanaged, boolean isBankLoginChanaged) {
        List customfilter;
        if (searchClickEvent.getFilterValues() != null && (customfilter = (List)searchClickEvent.getFilterValues().get("customfilter")) != null) {
            for (Map filteritem : customfilter) {
                String fieldName = ((List)filteritem.get("FieldName")).get(0).toString();
                if (!isBankVersionChanaged || !fieldName.startsWith("bd_bank_login")) continue;
                this.commonFilterChange(filteritem);
                this.getPageCache().put("selectedBankLoginId", null);
            }
        }
    }

    protected void commonFilterChange(Map<String, List<Object>> commonFilter) {
        if (commonFilter != null) {
            ArrayList<String> commonList = new ArrayList<String>(16);
            commonList.add("");
            commonFilter.put("Value", commonList);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean isInit = Objects.equals(this.getView().getPageCache().get(INIT_CACHE_KEY), "YES");
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        if (qFilters.size() > 0) {
            HashMap qFilterMap = Maps.newHashMapWithExpectedSize((int)16);
            for (QFilter qFilter : qFilters) {
                String value = qFilter.getValue().toString();
                if (qFilter.getValue() instanceof List) {
                    value = ((List)qFilter.getValue()).get(0).toString();
                }
                qFilterMap.put(qFilter.getProperty(), value);
            }
        }
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List currencyItems;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.equals("bd_bank_login.number")) {
                List<ComboItem> bankLoginItems = this.initBankLoginItemsList();
                currencyItems = commonFilterColumn.getComboItems();
                currencyItems.clear();
                commonFilterColumn.setComboItems(bankLoginItems);
                continue;
            }
            if (!fieldName.equals("bd_bank_version.name")) continue;
            List<ComboItem> bankVersionItems = this.initBankVersionItemsList();
            currencyItems = commonFilterColumn.getComboItems();
            currencyItems.clear();
            commonFilterColumn.setComboItems(bankVersionItems);
            if (bankVersionItems.size() <= 0 || !isInit) continue;
            this.getView().getPageCache().put(INIT_CACHE_KEY, "YES");
            commonFilterColumn.setDefaultValue(bankVersionItems.get(0).getValue());
            this.getPageCache().put("selectedBankId", bankVersionItems.get(0).getValue());
        }
    }

    protected List<ComboItem> initBankLoginItemsList() {
        ArrayList<ComboItem> bankLoginItems = new ArrayList<ComboItem>(16);
        QFilter[] qfilters = new QFilter[3];
        String selectProperties = "id, number, name";
        if (!StringUtils.isNotEmpty(this.getPageCache().get("selectedBankId"))) {
            return bankLoginItems;
        }
        qfilters[0] = new QFilter("group.id", "=", (Object)Long.parseLong(this.getPageCache().get("selectedBankId")));
        qfilters[1] = new QFilter("enable", "=", (Object)"1");
        qfilters[2] = new QFilter("config_type", "=", (Object)"0");
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)ENTITY_KEY_BANK_LOGIN, (String)selectProperties, (QFilter[])qfilters);
        if (accountBanks != null && accountBanks.length > 0) {
            for (int i = 0; i < accountBanks.length; ++i) {
                DynamicObject cashAcct = accountBanks[i];
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("number")));
                item.setValue(cashAcct.getString("id"));
                bankLoginItems.add(item);
            }
        }
        return bankLoginItems;
    }

    protected List<ComboItem> initBankVersionItemsList() {
        List<BankVersionInfo> bankVersionList = this.infoService.getBankVersionInfoList();
        ArrayList<String> bankVersionIDList = new ArrayList<String>(16);
        for (BankVersionInfo bankVersionInfo : bankVersionList) {
            bankVersionIDList.add(bankVersionInfo.getBankVersionID());
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        String selectProperties = "id, number, name";
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"aqap_bank", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("number", "in", bankVersionIDList), QFilter.of((String)"enable=? and status=?", (Object[])new Object[]{"1", "C"})});
        if (objects != null && objects.length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                DynamicObject cashAcct = objects[i];
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("name")));
                item.setValue(cashAcct.getString("id"));
                items.add(item);
            }
        }
        return items;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        String SearchCondition = this.getPageCache().get("SearchCondition");
        String customID = RequestContext.get().getTenantId();
        if (StringUtil.isNil(SearchCondition) && this.getPageCache().get("isFirstInit") == null) {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime start = this.getStartTime(now);
            Date datestart = Date.from(start.atZone(ZoneOffset.ofHours(8)).toInstant());
            Date dateend = Date.from(now.atZone(ZoneOffset.ofHours(8)).toInstant());
            this.getPageCache().put("startDateTime", DateUtil.formatDate((Date)datestart, (String)"yyyy-MM-dd HH:mm:ss"));
            this.getPageCache().put("endDateTime", DateUtil.formatDate((Date)dateend, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        String startTime1 = this.getPageCache().get("startDateTime");
        String endTime1 = this.getPageCache().get("endDateTime");
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date s = new Date();
        Date e = new Date();
        try {
            s = sf.parse(startTime1);
            e = sf.parse(endTime1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!DateUtil.isSameDay((Date)s, (Date)e)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u67e5\u8be2\u540c\u4e00\u5929\u7684\u8bb0\u5f55\uff0c\u76d1\u63a7\u65e5\u671f\u8303\u56f4\u8bf7\u9009\u62e9\u540c\u4e00\u5929\u3002", (String)"BankLoginBusyMonitor_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            return;
        }
        final IPageCache iPageCache = this.getPageCache();
        final String dataCountCacheKey = "page_data_data_count";
        LocalDateTime startTime = LocalDateTime.parse(iPageCache.get("startDateTime"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime endTime = LocalDateTime.parse(iPageCache.get("endDateTime"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        Map infoMap = this.bankReqRecordRepository.getStatisticMapByCustomID(customID, startTime, endTime);
        HashMap details = new HashMap(16);
        String date = startTime.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        if (!StringUtil.isNil(iPageCache.get("selectedBankLoginId"))) {
            String bankLoginID = iPageCache.get("selectedBankLoginId");
            String string = this.bankLoginRepository.findByFId(bankLoginID, customID).getBankLoginName();
            for (Map.Entry m : infoMap.entrySet()) {
                if (!((String)m.getKey()).equalsIgnoreCase(string)) continue;
                List list = ((List)m.getValue()).stream().filter(a -> a.getTimeSlot().startsWith(date)).collect(Collectors.toList());
                details.put(m.getKey(), list);
            }
        } else if (StringUtil.isNil(iPageCache.get("selectedBankLoginId")) && StringUtil.isNotNil(iPageCache.get("selectedBankId"))) {
            QFilter[] qfilters = new QFilter[3];
            String string = "id, number, name";
            qfilters[0] = new QFilter("group.id", "=", (Object)Long.parseLong(this.getPageCache().get("selectedBankId")));
            qfilters[1] = new QFilter("enable", "=", (Object)"1");
            qfilters[2] = new QFilter("config_type", "=", (Object)"0");
            Map accountBanks = BusinessDataServiceHelper.loadFromCache((String)ENTITY_KEY_BANK_LOGIN, (String)string, (QFilter[])qfilters);
            if (accountBanks != null && accountBanks.size() > 0) {
                for (Map.Entry entry : accountBanks.entrySet()) {
                    DynamicObject cashAcct = (DynamicObject)entry.getValue();
                    String bankLoginID = cashAcct.getString("number");
                    for (Map.Entry m : infoMap.entrySet()) {
                        if (!((String)m.getKey()).equalsIgnoreCase(bankLoginID)) continue;
                        List list = ((List)m.getValue()).stream().filter(a -> a.getTimeSlot().startsWith(date)).collect(Collectors.toList());
                        details.put(m.getKey(), list);
                    }
                }
            }
        } else {
            for (Map.Entry entry : infoMap.entrySet()) {
                List list = ((List)entry.getValue()).stream().filter(a -> a.getTimeSlot().startsWith(date)).collect(Collectors.toList());
                details.put(entry.getKey(), list);
            }
        }
        final ArrayList<LoginBusyMonitorInfo> totalInfos = new ArrayList<LoginBusyMonitorInfo>(16);
        for (Map.Entry m : details.entrySet()) {
            List d = (List)m.getValue();
            for (LoginMonitorStatisticInfo oneDetail : d) {
                LoginBusyMonitorInfo loginBusyMonitorInfo = new LoginBusyMonitorInfo();
                loginBusyMonitorInfo.setBankLoginID((String)m.getKey());
                loginBusyMonitorInfo.setLoginMonitorStatisticInfo(oneDetail);
                totalInfos.add(loginBusyMonitorInfo);
            }
        }
        totalInfos.sort(Comparator.comparing(LoginBusyMonitorInfo::getBankLoginID));
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public int getRealCount() {
                return totalInfos.size();
            }

            public DynamicObjectCollection getData(int start, int limit) {
                int page = 0;
                List<LoginBusyMonitorInfo> finalData = this.getStartToEnd(start, limit, totalInfos, page);
                DynamicObjectCollection dObjectCollection = this.getCollection(finalData, page, limit);
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(dObjectCollection.size());
                iPageCache.put(dataCountCacheKey, dObjectCollection.size() + "");
                return dObjectCollection;
            }

            private List<LoginBusyMonitorInfo> getStartToEnd(int start, int limit, List<LoginBusyMonitorInfo> totalInfos2, int page) {
                ArrayList<LoginBusyMonitorInfo> data = new ArrayList<LoginBusyMonitorInfo>();
                int end = start + limit;
                int size = totalInfos2.size();
                if (size >= end) {
                    for (int i = start; i < end; ++i) {
                        LoginBusyMonitorInfo dynamicObject = totalInfos2.get(i);
                        data.add(dynamicObject);
                    }
                } else {
                    for (int i = start; i < size; ++i) {
                        LoginBusyMonitorInfo dynamicObject = totalInfos2.get(i);
                        data.add(dynamicObject);
                    }
                }
                return data;
            }

            private DynamicObjectCollection getCollection(List<LoginBusyMonitorInfo> totalInfos2, int page, int pageSize) {
                String selectFields = "id, time_slot, bank_login, block_num, normal_num, block_rate, wait_time, process_time, use_rate";
                String[] fields = new String[]{"id", "time_slot", "bank_login", "block_num", "normal_num", "block_rate", "wait_time", "process_time", "use_rate"};
                DataType[] datatype = new DataType[]{DataType.IntegerType, DataType.AnyType, DataType.AnyType, DataType.LongType, DataType.LongType, DataType.StringType, DataType.LongType, DataType.LongType, DataType.StringType};
                DynamicObjectCollection dCollection = QueryServiceHelper.query((String)"aqap_login_busy_monitor", (String)selectFields, null);
                if (totalInfos2.isEmpty()) {
                    return dCollection;
                }
                int i = 0;
                ArrayList<Object[]> coll = new ArrayList<Object[]>(10);
                for (LoginBusyMonitorInfo l : totalInfos2) {
                    coll.add(new Object[]{page * pageSize + i++, l.getLoginMonitorStatisticInfo().getTimeSlot(), l.getBankLoginID(), l.getLoginMonitorStatisticInfo().getBlockCount(), l.getLoginMonitorStatisticInfo().getTotalCount() - l.getLoginMonitorStatisticInfo().getBlockCount(), l.getLoginMonitorStatisticInfo().getBlockRate(), l.getLoginMonitorStatisticInfo().getTotalBlockTime(), l.getLoginMonitorStatisticInfo().getTotalProcessTime(), l.getLoginMonitorStatisticInfo().getProcessRate()});
                }
                RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields, (DataType[])datatype);
                CollectionInput inputs = new CollectionInput(rowMeta, coll);
                DataSet resultDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
                if (!BankLoginBusyMonitor.this.rowQFilter.isEmpty()) {
                    resultDataSet = resultDataSet.filter(((QFilter)BankLoginBusyMonitor.this.rowQFilter.get(0)).toString());
                }
                for (Row row : resultDataSet) {
                    DynamicObject data = dCollection.addNew();
                    data.set("id", row.get("id"));
                    data.set("time_slot", row.get("time_slot"));
                    data.set("bank_login", row.get("bank_login"));
                    data.set("block_num", row.get("block_num"));
                    data.set("normal_num", row.get("normal_num"));
                    data.set("block_rate", row.get("block_rate"));
                    data.set("wait_time", row.get("wait_time"));
                    data.set("process_time", row.get("process_time"));
                    data.set("use_rate", row.get("use_rate"));
                }
                return dCollection;
            }
        });
    }

    private LocalDateTime getStartTime(LocalDateTime now) {
        int year = now.getYear();
        int month = now.getMonthValue();
        int dayOfMonth = now.getDayOfMonth();
        return LocalDateTime.of(year, month, dayOfMonth, 0, 0, 0);
    }

    public void showFormPage(String entityKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(entityKey);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(showParameter);
    }
}

