/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.paramsconfig;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class DetailNoteFieldListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String ENTITY_KEY_CUSTOM_NOTE = "aqap_custom_note";
    private static final String selectColumn = "id,number,name,bank_version";
    private static String ENTITY_KEY_BANK = "aqap_bank";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        Lang lang;
        super.beforeCreateListColumns(args);
        if (StringUtils.equals((CharSequence)"bos_listf7", (CharSequence)this.getView().getFormShowParameter().getFormId()) && (lang = Lang.get()).getLangTag().equalsIgnoreCase("en-US")) {
            List columns = args.getListColumns();
            Iterator iterators = columns.iterator();
            while (iterators.hasNext()) {
                IListColumn column = (IListColumn)iterators.next();
                if (!kd.ebg.egf.common.utils.string.StringUtils.equals((String)"name", (String)column.getListFieldKey())) continue;
                iterators.remove();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        List filters = ((BillList)args.getSource()).getQueryFilterParameter().getQFilters();
        String filterValue = "";
        if (CollectionUtil.isNotEmpty((Collection)filters)) {
            String filter = (String)((QFilter)filters.get(0)).getValue();
            filterValue = filter.substring(filter.indexOf("#") + 1);
        }
        String bank_version = this.getView().getParentView().getPageCache().get("bank_version");
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)bank_version)};
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)ENTITY_KEY_BANK, (String)"id", (QFilter[])qFilters);
        Long bankVersion = null;
        if (!CollectionUtil.isEmpty((Collection)dynamicObjectCollection)) {
            bankVersion = ((DynamicObject)dynamicObjectCollection.get(0)).getLong("id");
        }
        final DynamicObjectCollection dataCollection = this.getCollection(bankVersion, filterValue);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public int getRealCount() {
                return dataCollection.size();
            }

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dObjectCollection = this.getStartToEnd(start, limit, dataCollection);
                int dataCount = dataCollection.size();
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(dataCount);
                return dObjectCollection;
            }

            private DynamicObjectCollection getStartToEnd(int start, int limit, DynamicObjectCollection dCollection) {
                DynamicObjectCollection data = new DynamicObjectCollection();
                int end = start + limit;
                int size = dCollection.size();
                if (size >= end) {
                    for (int i = start; i < end; ++i) {
                        DynamicObject dynamicObject = (DynamicObject)dCollection.get(i);
                        data.add((Object)dynamicObject);
                    }
                } else {
                    for (int i = start; i < size; ++i) {
                        DynamicObject dynamicObject = (DynamicObject)dCollection.get(i);
                        data.add((Object)dynamicObject);
                    }
                }
                return data;
            }
        });
    }

    private DynamicObjectCollection getCollection(Long bankVersion, String filterValue) {
        QFilter[] qFilters = null;
        if (bankVersion != null) {
            qFilters = new QFilter[]{new QFilter("bank_version", "=", (Object)bankVersion)};
        }
        DynamicObjectCollection dCollection = QueryServiceHelper.query((String)ENTITY_KEY_CUSTOM_NOTE, (String)selectColumn, qFilters);
        if (StringUtil.isNotNil(filterValue)) {
            ListIterator dynamicObjectListIterator = dCollection.listIterator();
            while (dynamicObjectListIterator.hasNext()) {
                DynamicObject next = (DynamicObject)dynamicObjectListIterator.next();
                if (next.get("number").toString().contains(filterValue)) continue;
                dynamicObjectListIterator.remove();
            }
        }
        return dCollection;
    }
}

