/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.paramsconfig;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.formplugin.plugin.common.EbcAddBankListPlugin;
import kd.ebg.egf.common.log.EBGLogger;
import org.apache.commons.lang3.StringUtils;

public class DetailNoteRuleConfigListPlugin
extends EbcAddBankListPlugin {
    public static List<String> TENANT_LIST = Arrays.asList("tenant_feature_sit_fi_test", "tenant_devfi_dev");
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailNoteRuleConfigListPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String tenantID = RequestContext.get().getTenantId();
        boolean isHide = TENANT_LIST.contains(tenantID);
        this.getView().setVisible(Boolean.valueOf(isHide), new String[]{"tblnew", "baritemap1", "tbldel", "tblnamehistory"});
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.isCancel()) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("new".equals(operateKey) || "modify".equals(operateKey) || "enable".equals(operateKey) || "disable".equalsIgnoreCase(operateKey)) {
            this.log.monitorFeature("sk_2024_037_013", "aqap_detail_note_config", operateKey, "DetailNoteRuleConfigListPlugin");
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        HashSet bankVersion = new HashSet();
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"aqap_detail_note_config", (String)"bank_version", null);
        dynamicObjectCollection.forEach(aqap_detail_note_config -> bankVersion.add(aqap_detail_note_config.getString("bank_version")));
        DynamicObjectCollection detailNoteConfigs = this.getDetailNoteConfig();
        ArrayList bankList = Lists.newArrayList();
        detailNoteConfigs.forEach(detailNoteConfig -> bankList.add(detailNoteConfig.getString("object_id")));
        DynamicObjectCollection detailNoteDetailConfigs = this.getDetailNoteDetailConfig(bankList);
        detailNoteDetailConfigs.forEach(detailNoteDetailConfig -> {
            String attr_value = detailNoteDetailConfig.getString("attr_value");
            String object_id = detailNoteDetailConfig.getString("object_id");
            if (!bankVersion.contains(object_id)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"aqap_detail_note_config");
                DynamicObjectCollection aqap_detail_note_rule = dynamicObject.getDynamicObjectCollection("aqap_detail_note_rule");
                DynamicObjectType dynamicObjectType = aqap_detail_note_rule.getDynamicObjectType();
                long fid = ID.genLongId();
                dynamicObject.set("id", (Object)fid);
                dynamicObject.set("status", (Object)"C");
                dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("enable", (Object)"1");
                Date insertTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
                dynamicObject.set("createtime", (Object)insertTime);
                dynamicObject.set("modifytime", (Object)insertTime);
                dynamicObject.set("masterid", (Object)fid);
                DynamicObject data = BusinessDataServiceHelper.loadSingle((String)"aqap_bank", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)object_id)});
                if (data != null) {
                    dynamicObject.set("group", (Object)data.getLong("id"));
                }
                dynamicObject.set("bank_version", (Object)object_id);
                List lists = Lists.newArrayList();
                if (StringUtils.isNotBlank((CharSequence)attr_value)) {
                    lists = SerializationUtils.fromJsonStringToList((String)attr_value, Map.class);
                }
                StringBuilder fieldName = new StringBuilder();
                for (int i = 0; i < lists.size(); ++i) {
                    Map configMap = (Map)lists.get(i);
                    String field = (String)configMap.get("field");
                    String id = (String)configMap.get("id");
                    String logic = (String)configMap.get("logic");
                    String append = ",";
                    if (logic.equalsIgnoreCase("or")) {
                        append = "/";
                    }
                    fieldName.append(field).append(append);
                    DynamicObject entity = new DynamicObject(dynamicObjectType);
                    entity.set("id", (Object)ID.genLongId());
                    entity.set("detail_field", (Object)fid);
                    entity.set("seq", (Object)(i + 1));
                    entity.set("detail_field", (Object)id);
                    entity.set("logic", (Object)logic);
                    aqap_detail_note_rule.add(i, entity);
                }
                if (StringUtils.isNotBlank((CharSequence)fieldName.toString())) {
                    dynamicObject.set("field_name", (Object)fieldName.substring(0, fieldName.length() - 1));
                } else {
                    dynamicObject.set("field_name", (Object)" ");
                }
                String number = object_id + "_" + ID.genStringId();
                dynamicObject.set("number", (Object)number);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
        });
        super.beforeCreateListDataProvider(args);
    }

    private DynamicObjectCollection getDetailNoteDetailConfig(List<String> bankList) {
        QFilter qFilter = QFilter.of((String)"attr_key=?", (Object[])new Object[]{"detail_note_select_detail"});
        qFilter.and(new QFilter("object_id", "in", bankList));
        return QueryServiceHelper.query((String)"aqap_object_properties", (String)"id, attr_key, attr_value, object_id", (QFilter[])qFilter.toArray());
    }

    DynamicObjectCollection getDetailNoteConfig() {
        QFilter qFilter = QFilter.of((String)"attr_key=?", (Object[])new Object[]{"detail_note_select"});
        return QueryServiceHelper.query((String)"aqap_object_properties", (String)"id, attr_key, attr_value, object_id", (QFilter[])qFilter.toArray());
    }

    DynamicObjectCollection getAvailableBankVersionDatas() {
        QFilter qFilter = QFilter.of((String)"status=? and enable=?", (Object[])new Object[]{"C", "1"});
        return QueryServiceHelper.query((String)"aqap_bank", (String)"id, number, name, bank_name, status, enable,note_status", (QFilter[])qFilter.toArray());
    }
}

