/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.paramsconfig;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ComboColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.repository.BankLoginLinkCheckRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.plugin.baseplugin.EBGBasePlugin;
import kd.ebg.aqap.formplugin.plugin.util.ShowPageUtil;
import kd.ebg.aqap.formplugin.pojo.bizinfo.BankVersionInfo;
import kd.ebg.aqap.formplugin.service.info.InfoService;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.monitor.LoginLinkCheckInfo;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class LinkMonitorConnect
extends EBGBasePlugin {
    private static final String ENTITY_KEY_BANK_MONITOR = "aqap_login_link_monitor";
    private static final String ENTITY_KEY_BANK_MONITOR_SETTING_ACNT_KEY = "aqap_bank_monitor_acnt";
    private static final String ENTITY_KEY_OBJECT_PROPERTIES = "aqap_object_properties";
    private static final String ENTITY_KEY_BANK = "aqap_bank";
    private static final String selectFields = "id, number, update_time, bank_loginid, bank_name, acnt, type, state, message";
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);
    private BankLoginLinkCheckRepository bankLoginLinkCheckDetail = (BankLoginLinkCheckRepository)SpringContextUtil.getBean(BankLoginLinkCheckRepository.class);
    private BankLoginRepository bankLoginRepository = (BankLoginRepository)SpringContextUtil.getBean(BankLoginRepository.class);
    private LinkedList<QFilter> rowQFilter = new LinkedList();

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        this.rowQFilter.clear();
        this.rowQFilter.addAll(qFilters);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("monitor_setting".equals(formOperate.getOperateKey())) {
            this.showFormPage("aqap_login_link_m_setting");
        } else if ("set_acnt".equals(formOperate.getOperateKey())) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)ENTITY_KEY_BANK_MONITOR_SETTING_ACNT_KEY, (boolean)false, (int)0, (boolean)true);
            HashMap<String, String> customParams = new HashMap<String, String>(16);
            StyleCss style = new StyleCss();
            style.setWidth("1000");
            style.setHeight("600");
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            listShowParameter.getOpenStyle().setInlineStyleCss(style);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u8fde\u63a5\u76d1\u63a7\u8d26\u53f7\u8bbe\u7f6e", (String)"LinkMonitorConnect_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
            ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
            this.getPageCache().put("bankLoginID", listSelectedRowCollection.get(0).getNumber());
            customParams.put("bankLoginID", listSelectedRowCollection.get(0).getNumber());
            listShowParameter.setCustomParams(customParams);
            this.getView().showForm((FormShowParameter)listShowParameter);
            args.setCancel(true);
        } else if ("show_detail".equals(formOperate.getOperateKey())) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(16);
            ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
            LocalDateTime now = LocalDateTime.now();
            String startDateStr = DateUtil.transTimeZoneSystemToUser((LocalDateTime)now.minusDays(7L));
            String endDateStr = DateUtil.transTimeZoneSystemToUser((LocalDateTime)now);
            customParams.put("trans_date_start", startDateStr);
            customParams.put("trans_date_end", endDateStr);
            customParams.put("bankLoginID", listSelectedRowCollection.get(0).getNumber());
            ShowPageUtil.showListPage("aqap_login_link_m_detail", customParams, this.getView());
            args.setCancel(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection selectCollections = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            for (ListSelectedRow row : selectCollections) {
                this.delete(this.getPageCache().get("bankLoginID"));
                this.save(this.getPageCache().get("bankLoginID"), row.getNumber());
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"LinkMonitorConnect_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    public void packageData(PackageDataEvent evt) {
        Object obj = evt.getSource();
        DynamicObject rowData = evt.getRowData();
        String status = rowData.getString("state");
        int seq = rowData.getInt("id");
        if (obj instanceof ComboColumnDesc && "state".equals(((ComboColumnDesc)obj).getKey())) {
            if (ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38", (String)"LinkMonitorConnect_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]).equalsIgnoreCase(status)) {
                this.setListUnitStyle(seq, "#FB2323");
            } else if (ResManager.loadKDString((String)"\u8fde\u63a5\u6b63\u5e38", (String)"LinkMonitorConnect_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]).equalsIgnoreCase(status)) {
                this.setListUnitStyle(seq, "#1BA854");
            }
        }
    }

    private void setListUnitStyle(int row, String color) {
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(16);
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey("state");
        cellStyle.setRow(row);
        cellStyle.setForeColor(color);
        cellStyles.add(cellStyle);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.setCellStyle(cellStyles);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        String customID = RequestContext.get().getTenantId();
        final IPageCache iPageCache = this.getPageCache();
        final String dataCountCacheKey = "page_data_data_count_link";
        List bankLogins = this.bankLoginRepository.findAllByCustomerIDAndEnable(customID, "1");
        ArrayList bad = new ArrayList(16);
        ArrayList good = new ArrayList(16);
        Map map = this.bankLoginLinkCheckDetail.findLastState(customID);
        for (BankLogin b : bankLogins) {
            List details = (List)map.get(b.getKey().getBankLoginId());
            if (details != null && details.size() >= 1) {
                if ("exception".equals(((LoginLinkCheckInfo)details.get(0)).getStatus())) {
                    bad.add(details.get(0));
                    continue;
                }
                good.add(details.get(0));
                continue;
            }
            LoginLinkCheckInfo notCheck = new LoginLinkCheckInfo();
            notCheck.setBankLoginID(b.getKey().getBankLoginId());
            notCheck.setBankVersionID(b.getBankVersionId());
            notCheck.setCustomID(b.getKey().getCustomId());
            notCheck.setMessage(ResManager.loadKDString((String)"\u672a\u68c0\u6d4b", (String)"LinkMonitorConnect_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            notCheck.setStatus("notCheck");
            good.add(notCheck);
        }
        final ArrayList finalResult = new ArrayList(16);
        finalResult.addAll(bad);
        finalResult.addAll(good);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public int getRealCount() {
                return Integer.parseInt(iPageCache.get(dataCountCacheKey));
            }

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dObjectCollection = this.getCollection(finalResult);
                DynamicObjectCollection data = this.getStartToEnd(start, limit, dObjectCollection);
                this.getQueryResult().setCollection(data);
                this.getQueryResult().setDataCount(dObjectCollection.size());
                iPageCache.put(dataCountCacheKey, dObjectCollection.size() + "");
                return data;
            }

            private DynamicObjectCollection getStartToEnd(int start, int limit, DynamicObjectCollection dObjectCollection) {
                DynamicObjectCollection data = QueryServiceHelper.query((String)LinkMonitorConnect.ENTITY_KEY_BANK_MONITOR, (String)LinkMonitorConnect.selectFields, null);
                int end = start + limit;
                int size = dObjectCollection.size();
                if (end > size) {
                    end = size;
                }
                for (int i = start; i < end; ++i) {
                    DynamicObject dynamicObject = (DynamicObject)dObjectCollection.get(i);
                    data.add((Object)dynamicObject);
                }
                return data;
            }

            private DynamicObjectCollection getCollection(List<LoginLinkCheckInfo> details) {
                String[] fields = new String[]{"id", "number", "bank_loginid", "bank_name", "acnt", "state"};
                DataType[] datatype = new DataType[]{DataType.IntegerType, DataType.AnyType, DataType.AnyType, DataType.AnyType, DataType.AnyType, DataType.AnyType};
                DynamicObjectCollection dCollection = QueryServiceHelper.query((String)LinkMonitorConnect.ENTITY_KEY_BANK_MONITOR, (String)LinkMonitorConnect.selectFields, null);
                if (CollectionUtil.isEmpty(details)) {
                    return dCollection;
                }
                List<BankVersionInfo> bankVersionList = LinkMonitorConnect.this.infoService.getBankVersionInfoList();
                Map<String, String> linkCheckAcnt = LinkMonitorConnect.this.loadLinkCheckAcnt();
                ArrayList<Object[]> coll = new ArrayList<Object[]>();
                for (int i = 0; i < details.size(); ++i) {
                    LoginLinkCheckInfo d = details.get(i);
                    DynamicObject bankInfoByBankVersion = LinkMonitorConnect.this.getBankInfoByBankVersion(d.getBankVersionID());
                    if (Objects.isNull(bankInfoByBankVersion)) continue;
                    OrmLocaleValue localeBankName = (OrmLocaleValue)bankInfoByBankVersion.get("name");
                    String bankName = localeBankName.getLocaleValue();
                    coll.add(new Object[]{i, d.getBankLoginID(), d.getBankLoginID(), bankName, linkCheckAcnt.get(d.getBankLoginID()), "exception".equals(d.getStatus()) ? ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38", (String)"LinkMonitorConnect_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]) : ("normal".equals(d.getStatus()) ? ResManager.loadKDString((String)"\u8fde\u63a5\u6b63\u5e38", (String)"LinkMonitorConnect_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u68c0\u6d4b", (String)"LinkMonitorConnect_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]))});
                }
                RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields, (DataType[])datatype);
                CollectionInput inputs = new CollectionInput(rowMeta, coll);
                DataSet resultDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
                if (!LinkMonitorConnect.this.rowQFilter.isEmpty()) {
                    resultDataSet = resultDataSet.filter(((QFilter)LinkMonitorConnect.this.rowQFilter.get(0)).toString());
                }
                for (Row row : resultDataSet) {
                    DynamicObject data = dCollection.addNew();
                    data.set("id", row.get("id"));
                    data.set("number", row.get("number"));
                    data.set("bank_loginid", row.get("bank_loginid"));
                    data.set("bank_name", row.get("bank_name"));
                    data.set("acnt", row.get("acnt"));
                    data.set("state", row.get("state"));
                }
                return dCollection;
            }
        });
    }

    Map<String, String> loadLinkCheckAcnt() {
        QFilter filter = QFilter.of((String)"attr_key=? and object_name=?", (Object[])new Object[]{"query_account", "monitor_link"});
        String PROPERTIES = "attr_key, attr_value, object_id";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_KEY_OBJECT_PROPERTIES, (String)PROPERTIES, (QFilter[])filter.toArray());
        HashMap<String, String> linkCheckAcnt = new HashMap<String, String>(16);
        for (DynamicObject d : dynamicObjects) {
            linkCheckAcnt.put(d.getString("object_id"), d.getString("attr_value"));
        }
        return linkCheckAcnt;
    }

    void delete(String bankLoginID) {
        QFilter[] qFilters = new QFilter[]{new QFilter("attr_key", "=", (Object)"query_account"), new QFilter("object_id", "=", (Object)bankLoginID)};
        DeleteServiceHelper.delete((String)ENTITY_KEY_OBJECT_PROPERTIES, (QFilter[])qFilters);
    }

    OperationResult save(String bankLoginID, String acnt) {
        String objectName = "monitor_link";
        String customID = RequestContext.get().getTenantId();
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES);
        dataEntity.set("attr_key", (Object)"query_account");
        dataEntity.set("attr_value", (Object)acnt);
        dataEntity.set("object_id", (Object)bankLoginID);
        dataEntity.set("object_name", (Object)objectName);
        dataEntity.set("custom_id", (Object)customID);
        DynamicObject[] dataEntities = new DynamicObject[]{dataEntity};
        return SaveServiceHelper.saveOperate((String)ENTITY_KEY_OBJECT_PROPERTIES, (DynamicObject[])dataEntities, (OperateOption)OperateOption.create());
    }

    public void showListPage(String entityKey) {
        this.showListPage(entityKey, "bos_list");
    }

    public void showListPage(String entityKey, String formId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId(formId);
        showParameter.setBillFormId(entityKey);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void showFormPage(String entityKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(entityKey);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(showParameter);
    }

    DynamicObject getBankInfoByBankVersion(String bankVersion) {
        QFilter qFilter = QFilter.of((String)"number=?", (Object[])new Object[]{bankVersion});
        return BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_KEY_BANK, (String)"id, number, name, bank_name, status, enable,bank_type,mature,biz_type,type,note", (QFilter[])qFilter.toArray());
    }
}

