/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.reconciliation;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.db.QueryCacheUtil;

public class ReconciliationFormPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    public static String properties = "id,group,number,name,biz_type,interface_code,content_type,node_name,node_path,bank_field_size,kd_flag,kd_size,is_merge,is_bank_ref,state";

    public void afterBindData(EventObject e) {
        this.updateNumber();
    }

    private void updateNumber() {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("group");
        String bankVersion = basedataEdit.getModel().getDataEntity().getString("group.number");
        this.getModel().setValue("bank_version_code", (Object)bankVersion);
        this.getView().updateView("bank_version_code");
        if (StringUtils.isEmpty((String)this.getModel().getValue("number"))) {
            String number = ID.genStringId();
            this.getModel().setValue("number", (Object)number);
            this.getModel().setValue("name", (Object)bankVersion);
            this.getView().updateView("number");
            this.getView().updateView("name");
        }
        String dateTimeStr = DateUtil.transTimeZoneSystemToUser((LocalDateTime)LocalDateTime.now());
        this.getModel().setValue("op_time", (Object)dateTimeStr);
        this.getView().updateView("op_time");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("save".equalsIgnoreCase(operateKey)) {
            boolean isBankRef = Boolean.parseBoolean((String)this.getModel().getValue("is_bank_ref"));
            String state = (String)this.getModel().getValue("state");
            if (isBankRef && "0".equalsIgnoreCase(state)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8bbe\u6570\u636e\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"ReconciliationFormPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                DynamicObject bankVersionDO;
                Long bankVersion;
                String number = (String)this.getModel().getValue("number");
                String nodeName = (String)this.getModel().getValue("node_name");
                String nodePath = (String)this.getModel().getValue("node_path");
                DynamicObject interfaceDO = (DynamicObject)this.getModel().getValue("interface_code");
                Long interfaceCode = interfaceDO.getLong("id");
                QFilter qFilter = QFilter.of((String)"interface_code=? and group=?", (Object[])new Object[]{interfaceCode, bankVersion = Long.valueOf((bankVersionDO = (DynamicObject)this.getModel().getValue("group")).getLong("id"))});
                List dynamicObjectList = QueryCacheUtil.getDynamicObjectList((String)"aqap_reconciliation_rule", (String)properties, (QFilter[])qFilter.toArray());
                if (dynamicObjectList.size() > 0) {
                    for (DynamicObject dynamicObject : dynamicObjectList) {
                        boolean isSame = true;
                        if (status == OperationStatus.ADDNEW || !number.equals(dynamicObject.getString("number"))) {
                            isSame = isSame && nodeName.equals(dynamicObject.getString("node_name"));
                            if (!(isSame = isSame && nodePath.equals(dynamicObject.getString("node_path")))) continue;
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f53\u524d\u94f6\u884c\u63a5\u53e3\u5bf9\u8d26\u7801\u5b57\u6bb5\u7684\u89c4\u5219\u3002", (String)"ReconciliationFormPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            continue;
                        }
                        if (status != OperationStatus.EDIT) continue;
                        DynamicObject hisDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"aqap_rc_history_rule");
                        hisDynamicObject.set("id", (Object)ID.genLongId());
                        hisDynamicObject.set("group", dynamicObject.get("group"));
                        hisDynamicObject.set("number", dynamicObject.get("number"));
                        hisDynamicObject.set("name", dynamicObject.get("name"));
                        hisDynamicObject.set("biz_type", dynamicObject.get("biz_type"));
                        hisDynamicObject.set("interface_code", dynamicObject.get("interface_code"));
                        hisDynamicObject.set("content_type", dynamicObject.get("content_type"));
                        hisDynamicObject.set("node_name", dynamicObject.get("node_name"));
                        hisDynamicObject.set("node_path", dynamicObject.get("node_path"));
                        hisDynamicObject.set("bank_field_size", dynamicObject.get("bank_field_size"));
                        hisDynamicObject.set("kd_flag", dynamicObject.get("kd_flag"));
                        hisDynamicObject.set("kd_size", dynamicObject.get("kd_size"));
                        hisDynamicObject.set("is_merge", dynamicObject.get("is_merge"));
                        hisDynamicObject.set("is_bank_ref", dynamicObject.get("is_bank_ref"));
                        hisDynamicObject.set("state", dynamicObject.get("state"));
                        hisDynamicObject.set("status", (Object)"A");
                        hisDynamicObject.set("operate", (Object)"update");
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{hisDynamicObject});
                    }
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("interface_code");
        if (fieldEdit != null) {
            fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String bizType = (String)this.getModel().getValue("biz_type");
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("group");
        String bankVersionID = basedataEdit.getModel().getDataEntity().getString("group.number");
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
        qFilterList.add(new QFilter("number", "=", (Object)bankVersionID));
        showParameter.getTreeFilterParameter().setQFilters(qFilterList);
        showParameter.getListFilterParameter().setFilter(new QFilter("group.number", "=", (Object)bankVersionID));
        showParameter.getListFilterParameter().setFilter(new QFilter("biz_type.number", "=", (Object)bizType));
    }
}

