/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.repository;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.annotation.Component;

@Component
public class EbcBankAcntRepository {
    private static final String ENTITY_NAME = "aqap_bank_acnt";

    public String getBankVersionByAcntID(Long bankAcntid) {
        String selectField = "group.number";
        DynamicObjectCollection datas = QueryServiceHelper.query((String)ENTITY_NAME, (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bankAcntid)});
        if (datas == null || datas.size() == 0) {
            return "";
        }
        String bankVersioin = (String)((DynamicObject)datas.get(0)).get(selectField);
        return bankVersioin;
    }

    public boolean exitsAcntByBankLogin(String bankLogin) {
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("bank_login.number", "=", (Object)bankLogin), new QFilter("enable", "=", (Object)"1")});
    }

    public boolean existAcntByBankVersonAndCurrency(String bankVersion, String currency) {
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)bankVersion), new QFilter("currency.number", "=", (Object)currency), new QFilter("enable", "=", (Object)"1")});
    }

    public DynamicObject getAcntByID(Long ID2) {
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)"number, currency.number, group.bank_name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ID2)});
    }

    public DynamicObject getAcntByAccno(String accno) {
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)"number, group, group.bank_name, bank_login, status, enable, custom_id, has_receipt,country,has_note", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)accno)});
    }

    public DynamicObject[] selectByBankVersionIdAndCustomId(Long bankVersionId, String customId) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"number, group, bank_login", (QFilter[])new QFilter[]{new QFilter("group.id", "=", (Object)bankVersionId), new QFilter("custom_id", "=", (Object)customId), new QFilter("enable", "=", (Object)"1")});
        return dynamicObjects;
    }

    public DynamicObject[] selectByBankVersionAndHasReceipt(String bankVersion, boolean hasReceipt) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"number, group, bank_login", (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)bankVersion), new QFilter("has_receipt", "=", (Object)(hasReceipt ? 1 : 0))});
        return dynamicObjects;
    }

    public DynamicObject[] selectByBankLoginAndHasReceipt(String bankLogin, boolean hasReceipt) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"number, group, bank_login", (QFilter[])new QFilter[]{new QFilter("bank_login.number", "=", (Object)bankLogin), new QFilter("has_receipt", "=", (Object)(hasReceipt ? 1 : 0))});
        return dynamicObjects;
    }

    public DynamicObject[] getAcntByAccnoList(List<String> accnoList) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"number, group, group.bank_name, bank_login, status, enable, custom_id, has_receipt,country,has_note", (QFilter[])new QFilter[]{new QFilter("number", "in", accnoList)});
        return dynamicObjects;
    }
}

