/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzrcb.dc.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzrcb.dc.service.utils.PackerUtil;
import kd.ebg.aqap.banks.gzrcb.dc.service.utils.ParserUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.utils.BankResponseResult;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public static final String TRANSCODE = "YQ261";

    public String pack(BankBalanceRequest rqst) {
        Element body = PackerUtil.buildBody();
        JDomUtils.addChild((Element)body, (String)"KEHHAO", (String)RequestContextUtils.getBankParameterValue((String)"customNo"));
        JDomUtils.addChild((Element)body, (String)"KEHUZH", (String)rqst.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"NAOFAC", (String)"0000");
        JDomUtils.addChild((Element)body, (String)"QISHBS", (String)"");
        JDomUtils.addChild((Element)body, (String)"CXUNBS", (String)"");
        StringBuilder builder = new StringBuilder();
        builder.append(RequestContextUtils.getBankParameterValue((String)"userNo")).append("|").append(RequestContextUtils.getBankParameterValue((String)"customNo")).append("|").append(rqst.getAcnt().getAccNo());
        PackerUtil.setSignPlainText(body, builder.toString());
        return PackerUtil.getPackedStr(TRANSCODE, PackerUtil.buildRoot(body));
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        EBBankBalanceResponse response = new EBBankBalanceResponse();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element header = JDomUtils.getChildElement((Element)root, (String)"comm_head");
        BankResponseResult result = ParserUtil.paserHeadResponse(header);
        ArrayList<BalanceInfo> infos = new ArrayList<BalanceInfo>();
        if (result.isSuccess()) {
            Element body = JDomUtils.getChildElement((Element)root, (String)"main_data");
            Element list = JDomUtils.getChildElement((Element)body, (String)"list_01");
            List rows = list.getChildren("row");
            for (Element row : rows) {
                BalanceInfo info = new BalanceInfo();
                info.setBankAcnt(request.getAcnt());
                String currecny = JDomUtils.getChildText((Element)row, (String)"HUOBDH");
                this.setBankCurrency(info, request.getBankCurrency(), currecny);
                String balance = JDomUtils.getChildText((Element)row, (String)"ZHHUYE");
                this.setCurrentBalance(info, balance);
                String avabal = JDomUtils.getChildText((Element)row, (String)"AVABAL");
                this.setAvailableBalance(info, avabal);
                info.setBalanceDateTime(LocalDateTime.now());
                infos.add(info);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)result.getResponseCode(), (String)result.getBankMessage()));
        }
        response.setBalances(infos);
        return response;
    }

    public String getDeveloper() {
        return "kiki";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u4eca\u65e5\u4f59\u989d", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-gzrcb-dc", (Object[])new Object[0]);
    }
}

