/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jxb.dc.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jxb.dc.service.util.Packer;
import kd.ebg.aqap.banks.jxb.dc.service.util.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = Packer.buildHead(Sequence.gen18Sequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)accNo);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        if (!"FIN0000".equals(bankResponse.getResponseCode())) {
            String resMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u4fe1\u606f\uff1a%3$s\u3002", (String)"TodayBalanceImpl_3", (String)"ebg-aqap-banks-jxb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"Body");
        Element activeList = JDomUtils.getChildElement((Element)resBody, (String)"ActiveList");
        List list = activeList.getChildren("Record");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        for (int i = 0; i < list.size(); ++i) {
            BalanceInfo balanceInfo = new BalanceInfo();
            Element record = (Element)list.get(i);
            this.setBankCurrency(balanceInfo, record.getChildText("Currency"));
            this.setBankAcnt(balanceInfo, request.getAcnt());
            this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
            String bal = record.getChildText("Balance");
            this.setCurrentBalance(balanceInfo, record.getChildText("Balance"));
            String avail = record.getChildText("AvailBal");
            if (StringUtils.isNotEmpty((String)avail)) {
                this.setAvailableBalance(balanceInfo, record.getChildText("AvailBal"));
            }
            balanceInfos.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "eacqry.AcBalQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u5f53\u524d\u4f59\u989d\u67e5\u8be2\u3002", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-jxb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        Packer.configFactory(factory, "eacqry.AcBalQry", "0");
    }
}

