/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scb.h2h.service.payment.company;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scb.h2h.service.SCBH2H_Packer;
import kd.ebg.aqap.banks.scb.h2h.service.SCBH2H_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "QUERY_BATCH_PAY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u652f\u4ed8\u7ed3\u679c\u540c\u6b65\u3002", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-scb-h2h", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element simulator = new Element("simulator");
        Element head = SCBH2H_Packer.createHead("QUERY_BATCH_PAY");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"reqCount", (String)("" + paymentInfos.length));
        JDomUtils.addChild((Element)reqPara, (String)"batchSequence", (String)paymentInfos[0].getBankBatchSeqId());
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element list = JDomUtils.addChild((Element)reqPara, (String)"list");
            JDomUtils.addChild((Element)list, (String)"serialNo", (String)paymentInfos[i].getBankDetailSeqId());
        }
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = SCBH2H_Parser.parseHeader(root);
        if ("BIZ_FAIL".equalsIgnoreCase(rsp.getResponseCode()) || !"BIZ_SUCCESS".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        List lists = rspPara.getChildren("list");
        if (null == lists || lists.size() == 0) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u5217\u8868\u4e3a\u7a7a\u3002", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-scb-h2h", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        for (int i = 0; i < lists.size(); ++i) {
            Element list = (Element)lists.get(i);
            String serialNo = JDomUtils.getChildTextTrim((Element)list, (String)"serialNo");
            String txStatus = JDomUtils.getChildTextTrim((Element)list, (String)"txStatus");
            Element status = JDomUtils.getChildElement((Element)list, (String)"status");
            String returnCode = JDomUtils.getChildTextTrim((Element)status, (String)"code");
            String returnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)serialNo);
            if (null == info) continue;
            if ("BCC_PAY_SUCCESS".equalsIgnoreCase(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"", (String)returnCode, (String)returnMsg);
                continue;
            }
            if ("BCC_PAY_ID_NOT_EXIST".equalsIgnoreCase(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)returnCode, (String)returnMsg);
                continue;
            }
            if ("BCC_PAY_FAIL".equalsIgnoreCase(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)returnCode, (String)returnMsg);
                continue;
            }
            if ("BCC_PAY_SUBMT_SUCCESS".equalsIgnoreCase(txStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)returnCode, (String)returnMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

