/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bcs.dc.service.payment.salary;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bcs.dc.service.payment.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.banks.bcs.dc.service.proxy.FileUploadUtil;
import kd.ebg.aqap.banks.bcs.dc.util.Common;
import kd.ebg.aqap.banks.bcs.dc.util.Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BCSSalaryPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String sameBankTemplate = "ACNO|CUR_CODE|ACNAME|CARDFLAG|AMT|POSTSCRIPT|";
        String otherBankTemplate = "ACNO|CUR_CODE|ACNAME|CARDFLAG|AMT|POSTSCRIPT|OPPBANKNAME|OPPBANKNO|";
        boolean isSameBank = ((PaymentInfo)paymentInfos.get(0)).is2SameBank();
        StringBuilder sb = new StringBuilder();
        if (isSameBank) {
            sb.append("ACNO|CUR_CODE|ACNAME|CARDFLAG|AMT|POSTSCRIPT|");
            sb.append("\r\n");
        } else {
            sb.append("ACNO|CUR_CODE|ACNAME|CARDFLAG|AMT|POSTSCRIPT|OPPBANKNAME|OPPBANKNO|");
            sb.append("\r\n");
        }
        BigDecimal totalAmt = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            BigDecimal amt = ((PaymentInfo)paymentInfos.get(i)).getAmount();
            totalAmt = totalAmt.add(amt);
            sb.append(((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo()).append("|");
            sb.append(((PaymentInfo)paymentInfos.get(i)).getCurrency()).append("|");
            sb.append(((PaymentInfo)paymentInfos.get(i)).getIncomeAccName()).append("|");
            sb.append('0').append("|");
            String amount = amt.setScale(2, 1).toPlainString();
            sb.append(amount).append("|");
            sb.append(((PaymentInfo)paymentInfos.get(i)).getExplanation()).append("|");
            if (!isSameBank) {
                sb.append(((PaymentInfo)paymentInfos.get(i)).getIncomeCnaps()).append("|").append(((PaymentInfo)paymentInfos.get(i)).getIncomeBankName()).append("|");
            }
            sb.append("\r\n");
        }
        String tr_code = "300002";
        Element ap = Packer.createCommonHead(tr_code, ((PaymentInfo)paymentInfos.get(0)).getPackageId(), "1");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)((PaymentInfo)paymentInfos.get(0)).getPackageId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)((PaymentInfo)paymentInfos.get(0)).getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)((PaymentInfo)paymentInfos.get(0)).getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"supply_item", (String)"0001");
        JDomUtils.addChild((Element)body, (String)"amt", (String)totalAmt.toPlainString());
        JDomUtils.addChild((Element)body, (String)"count", (String)String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        String fileName = ((PaymentInfo)paymentInfos.get(0)).getPackageId() + ".txt";
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        JDomUtils.addChild((Element)body, (String)"yqfhbz", (String)"0");
        JDomUtils.addChild((Element)body, (String)"bcs_khmode", (String)(isSameBank ? "0" : "1"));
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        try {
            FileUploadUtil fileUtil = new FileUploadUtil();
            fileUtil.setFileContent(sb.toString());
            fileUtil.doBiz(fileName);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"[\u4ee3\u53d1\u5de5\u8d44]\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002", (String)"BCSSalaryPayImpl_0", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return Common.createCommonMsg(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        rspStr = Common.parseRecvMsg(rspStr);
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = Common.parseBankResponse(head);
        String serialNo = "";
        try {
            serialNo = head.getChildTextTrim("serial_no");
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6serial_no\u5f02\u5e38\u3002", (String)"BCSSalaryPayImpl_1", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]), (Throwable)e);
        }
        if (!StringUtils.isEmpty((String)serialNo)) {
            PaymentInfoSysFiled.set((List)paymentInfos, (String)"HRXJBSerialNo", (String)serialNo);
        }
        if ("0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BCSSalaryPayImpl_2", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"BCSSalaryPayImpl_3", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "300002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"BCSSalaryPayImpl_4", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.getBankVersionID().equalsIgnoreCase("BCS_DC");
    }
}

