/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sxnxs.dc.services.payment;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sxnxs.dc.services.utils.MessageUtil;
import kd.ebg.aqap.banks.sxnxs.dc.services.utils.ParserRsp;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element Request = MessageUtil.getHead("702101", "YQBC05", Sequence.gen14Sequence());
        Element Body = new Element("Body");
        JDomUtils.addChild((Element)Body, (String)"CorpOldDate", (String)paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)Body, (String)"CorpOldSerialNo", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)Request, (Element)Body);
        String encoding = RequestContextUtils.getCharset();
        String xml = JDomUtils.root2String((Element)Request, (String)encoding);
        return MessageUtil.getSendMsg(xml);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        BankResponse res = ParserRsp.parseRsp(s);
        if (!"S".equals(res.getResponseCode()) && !"D".equals(res.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c:%s\u3002", (String)"QryPaymentImpl_4", (String)"ebg-aqap-banks-sxnxs-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{res.getResponseCode() + res.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element body = root.getChild("Body");
        Element recordList = body.getChild("RecordList");
        List records = recordList.getChildren("Record");
        for (Element element : records) {
            String RecStatus = element.getChildText("RecStatus");
            String RecErrCode = element.getChildText("RecErrCode");
            String RecErrMsg = element.getChildText("RecErrMsg");
            if ("S".equals(RecStatus)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u6210\u529f", (String)"QryPaymentImpl_1", (String)"ebg-aqap-banks-sxnxs-dc", (Object[])new Object[0]), (String)RecStatus, (String)RecErrMsg);
                continue;
            }
            if ("F".equals(RecStatus)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u4ea4\u6613\u5931\u8d25", (String)"QryPaymentImpl_2", (String)"ebg-aqap-banks-sxnxs-dc", (Object[])new Object[0]), (String)RecErrCode, (String)RecErrMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u72b6\u6001\u672a\u77e5", (String)"QryPaymentImpl_3", (String)"ebg-aqap-banks-sxnxs-dc", (Object[])new Object[0]), (String)RecErrCode, (String)RecErrMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

