/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.area;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.ebg.aqap.banks.boc.net.area.Area;
import kd.ebg.aqap.common.framework.services.BankAreaCodeService;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class AreaStoreExt {
    private static List<Area> areas;
    public static AreaStoreExt instance;

    public static synchronized AreaStoreExt getInstance() {
        if (null == instance) {
            instance = new AreaStoreExt();
        }
        return instance;
    }

    public AreaStoreExt() {
        BankAreaCodeService bankAreaCodeService = (BankAreaCodeService)SpringContextUtil.getBean(BankAreaCodeService.class);
        List lists = bankAreaCodeService.getBankAreaInfoByBankVersionId(EBContext.getContext().getBankVersionID());
        if (CollectionUtil.isNotEmpty((Collection)lists)) {
            areas = new ArrayList<Area>(lists.size());
            lists.forEach(bankAreaInfo -> {
                Area area = new Area();
                area.setAreaCode(bankAreaInfo.getCountryAreaCode());
                area.setAreaName(bankAreaInfo.getCountryArea());
                area.setKeywordList(bankAreaInfo.getKeywords());
                areas.add(area);
            });
        }
    }

    public Area matchArea(String address) {
        if (StringUtils.isNotEmpty((String)address)) {
            for (int i = 0; i < areas.size(); ++i) {
                if (!areas.get(i).getKeywordList().contains(address)) continue;
                return areas.get(i);
            }
        }
        return null;
    }
}

