/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.balance;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.service.CashPoolHelper;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.balance.AggregateBalanceImpl;
import kd.ebg.aqap.banks.boc.net.service.balance.HisBatchBalanceImpl;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBatchBalanceImpl
extends AbstractBalanceImpl
implements ITodayBatchBalance {
    EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBatchBalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public boolean match(BankBalanceRequest request) {
        boolean flag = !CashPoolHelper.isCashPoolAcnt(request.getHeader().getAcnt().getAccNo()) && !BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo()) && !BankBusinessConfig.isAggregatorsAcnt(request.getAcnt().getAccNo());
        if (request.getStartDate() != null && (flag &= BankBusinessConfig.isBatchBalanceQuery())) {
            return LocalDate.now().equals(request.getStartDate());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankBalanceRequest request) {
        List bankAcntList = request.getBankAcntList();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = Packer.getHeader(token, "b2e0005");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0005-rq");
            for (BankAcnt acnt : bankAcntList) {
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0005-rq");
                Element account = JDomUtils.addChild((Element)rq, (String)"account");
                JDomUtils.addChild((Element)account, (String)"ibknum", (String)acnt.getCnaps());
                JDomUtils.addChild((Element)account, (String)"actacn", (String)acnt.getAccNo());
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception e) {
                this.logger.error("\u6279\u91cf\u5f53\u65e5\u4f59\u989d\u63a5\u53e3\u67e5\u8be2\u6253\u5305\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError(root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0005-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equals(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspcod, (String)rspmsg));
        }
        List elements = trn.getChildren("b2e0005-rs");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(16);
        AggregateBalanceImpl impl = new AggregateBalanceImpl();
        BankBalanceRequest request1 = new BankBalanceRequest();
        BankHeader head = new BankHeader();
        request1.setHeader(head);
        List bankAcntList = request.getBankAcntList();
        for (Element rs : elements) {
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            Element account = rs.getChild("account");
            String actacn = account.getChildTextTrim("actacn");
            this.logger.info("\u89e3\u6790\u5230\u4e2d\u884c\u8fd4\u56de\u7684'\u8d26\u53f7'\u4e3a" + actacn);
            BalanceInfo balanceInfo = new BalanceInfo();
            this.setBankAcnt(balanceInfo, bankAcntList, actacn);
            balanceInfo.setBankCurrency(request.getBankCurrency());
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            if (!"B001".equals(another_rspcod)) {
                balanceInfo.setError(ShowTipUtil.getResponseErrorTips((String)another_rspcod, (String)another_rspmsg));
            } else {
                String acntname = account.getChildTextTrim("actname");
                String curcde = account.getChildTextTrim("curcde");
                Element balance = rs.getChild("balance");
                String bokbal = balance.getChildTextTrim("bokbal");
                String avabal = balance.getChildTextTrim("avabal");
                String baldat = rs.getChildTextTrim("baldat");
                this.setBankCurrency(balanceInfo, request.getCurrency(), curcde);
                this.setCurrentBalance(balanceInfo, bokbal);
                this.setAvailableBalance(balanceInfo, avabal);
                String frzamt = balance.getChildTextTrim("frzamt");
                this.setFreezeBalance(balanceInfo, frzamt);
            }
            balances.add(balanceInfo);
        }
        List<BalanceInfo> lastDayBalanceList = this.getBatchLastDayBalance(request);
        if (lastDayBalanceList != null) {
            block1: for (int i = 0; i < lastDayBalanceList.size(); ++i) {
                for (int j = 0; j < balances.size(); ++j) {
                    if (!lastDayBalanceList.get(i).getBankAcnt().getAccNo().equals(((BalanceInfo)balances.get(j)).getBankAcnt().getAccNo())) continue;
                    ((BalanceInfo)balances.get(j)).setLastDayAvlBalance(lastDayBalanceList.get(i).getAvailableBalance());
                    this.logger.info("\u4e0a\u65e5\u4f59\u989d\u5339\u914d\u6210\u529f\uff0c\u8d26\u53f7\uff1a" + lastDayBalanceList.get(i).getBankAcnt().getAccNo());
                    continue block1;
                }
            }
        }
        return new EBBankBalanceResponse(balances);
    }

    private List<BalanceInfo> getBatchLastDayBalance(BankBalanceRequest rqst) {
        try {
            LocalDate yesterday = LocalDate.now().minusDays(1L);
            BankBalanceRequest bankHisBalanceRequest = new BankBalanceRequest();
            bankHisBalanceRequest.setBankAcntList(rqst.getBankAcntList());
            bankHisBalanceRequest.setCurrency(rqst.getCurrency());
            bankHisBalanceRequest.setStartDate(yesterday);
            bankHisBalanceRequest.setEndDate(yesterday);
            bankHisBalanceRequest.setExtData(rqst.getExtData());
            bankHisBalanceRequest.setHeader(rqst.getHeader());
            EBBankBalanceResponse hisBalance = new HisBatchBalanceImpl().batchBalance(bankHisBalanceRequest);
            List balanceInfos = hisBalance.getBalances();
            if (null != balanceInfos && balanceInfos.size() > 0) {
                return balanceInfos;
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u4e2d\u884c\u4e0a\u65e5\u4f59\u989d\u51fa\u9519.", (Throwable)e);
        }
        return null;
    }

    public EBBankBalanceResponse batchBalance(BankBalanceRequest request) {
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        ArrayList balanceInfos = new ArrayList(16);
        EBBankBalanceResponse response = this.doBiz(request);
        balanceInfos.addAll(response.getBalances());
        ebBankBalanceResponse.setBalances(balanceInfos);
        return ebBankBalanceResponse;
    }

    public int limit() {
        return 15;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e0005";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"b2e0005\u5f53\u65e5\u4f59\u989d\u67e5\u8be2", (String)"TodayBatchBalanceImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }
}

