/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.payment.income;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.kit.FailCode;
import kd.ebg.aqap.banks.boc.net.service.BocNetUtils;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.banks.boc.net.service.payment.income.IncomeQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFieldConstants;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IncomePayImpl
extends AbstractPayImpl
implements IPay {
    private static final String SPECIALCHARS = "`~$^_|}{\\][:'oOiI\"%";

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IncomeQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "b2e0015";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u6536\u4e1a\u52a1(b2e0015)", (String)"IncomePayImpl_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return "income".equalsIgnoreCase(info.getSubBizType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest request) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            List paymentInfos = request.getPaymentInfos();
            if (BankBusinessConfig.isAddKDFlagToPay()) {
                PaymentUtil.setKdFlagIDByBankBatchSeqID((List)paymentInfos);
            }
            String token = la.getToken();
            String string = this.packIncomeMessage(paymentInfos.toArray(new PaymentInfo[paymentInfos.size()]), token);
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos;
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        boolean isError = Parser.parserB2eError(root, paymentInfos = request.getPaymentInfos());
        if (isError) {
            return new EBBankPayResponse(paymentInfos);
        }
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0015-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if ("1011".equalsIgnoreCase(rspcod)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)rspcod, (String)rspmsg);
            return new EBBankPayResponse(paymentInfos);
        }
        if (!"B001".equalsIgnoreCase(rspcod)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rspcod, (String)rspmsg);
            return new EBBankPayResponse(paymentInfos);
        }
        List list = trn.getChildren("b2e0015-rs");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Element rs = (Element)list.get(i);
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            if ("B001".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if ("1014".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if (FailCode.getInstance().isFail(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"IncomePayImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private String packIncomeMessage(PaymentInfo[] paymentInfos, String token) {
        Element root = BocNetUtils.createRoot();
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
        JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
        JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
        JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
        JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0015");
        JDomUtils.addChild((Element)head, (String)"token", (String)token);
        Element trans = JDomUtils.addChild((Element)root, (String)"trans");
        Element action = JDomUtils.addChild((Element)trans, (String)"trn-b2e0015-rq");
        Element record = JDomUtils.addChild((Element)action, (String)"b2e0015-rq");
        String insid = BocNetUtils.getBankBatchSeqId(paymentInfos[0]);
        JDomUtils.addChild((Element)record, (String)"insid", (String)insid);
        for (PaymentInfo info : paymentInfos) {
            info.setBankRefID(insid);
        }
        BocNetUtils.batchSetReservedSysField(paymentInfos, PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID, BocNetUtils.getSeqIdFromInsid(paymentInfos[0].getBankBatchSeqID()));
        Element toactn = JDomUtils.addChild((Element)record, (String)"toactn");
        JDomUtils.addChild((Element)toactn, (String)"toibkn", (String)paymentInfos[0].getAreaCode());
        JDomUtils.addChild((Element)toactn, (String)"toactacn", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)toactn, (String)"toname", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)record, (String)"pybcur", (String)"CNY");
        JDomUtils.addChild((Element)record, (String)"pybamt", (String)BigDecimalHelper.plain2((BigDecimal)this.calcTotalAmt(paymentInfos)));
        JDomUtils.addChild((Element)record, (String)"pybnum", (String)("" + paymentInfos.length));
        JDomUtils.addChild((Element)record, (String)"crdtpy", (String)(paymentInfos[0].getSameBank() != false ? "1" : "6"));
        JDomUtils.addChild((Element)record, (String)"touseinf", (String)"0");
        JDomUtils.addChild((Element)record, (String)"trfdate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)record, (String)"tofurinf", (String)ResManager.loadKDString((String)"\u4ee3\u6263", (String)"IncomePayImpl_2", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]));
        for (int i = 0; i < paymentInfos.length; ++i) {
            PaymentInfo info;
            Element detail = new Element("hisDetail");
            info = paymentInfos[i];
            if (paymentInfos[0].getSameBank().booleanValue()) {
                JDomUtils.addChild((Element)detail, (String)"fribkn", (String)info.getIncomeAreaCode());
            } else {
                JDomUtils.addChild((Element)detail, (String)"fribkn", (String)info.getIncomeCnaps());
            }
            JDomUtils.addChild((Element)detail, (String)"frbank", (String)info.getIncomeBankName());
            JDomUtils.addChild((Element)detail, (String)"pydcur", (String)info.getCurrency());
            JDomUtils.addChild((Element)detail, (String)"pydamt", (String)BigDecimalHelper.plain2((BigDecimal)info.getAmount()));
            JDomUtils.addChild((Element)detail, (String)"fractacn", (String)info.getIncomeAccNo());
            JDomUtils.addChild((Element)detail, (String)"frname", (String)info.getIncomeAccName());
            JDomUtils.addChild((Element)detail, (String)"frfurinf", (String)this.filterSpecialChars(info.getExplanation()));
            if (paymentInfos[i].getSameBank().booleanValue()) {
                JDomUtils.addChild((Element)detail, (String)"cntnum", (String)"");
            } else {
                JDomUtils.addChild((Element)detail, (String)"cntnum", (String)BankBusinessConfig.getCntNumByAcnt(info.getIncomeAccNo()));
            }
            JDomUtils.addChild((Element)record, (Element)detail);
        }
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    private String filterSpecialChars(String explanation) {
        if (StrUtil.isEmpty((String)explanation)) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < explanation.length(); ++i) {
            if (-1 != SPECIALCHARS.indexOf(explanation.charAt(i))) continue;
            buffer.append(explanation.charAt(i));
        }
        return buffer.toString();
    }

    private BigDecimal calcTotalAmt(PaymentInfo[] paymentInfos) {
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.length; ++i) {
            total = BigDecimalHelper.add((BigDecimal)total, (BigDecimal)paymentInfos[i].getAmount());
        }
        return total;
    }
}

