/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.payment.individual;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.kit.FailCode;
import kd.ebg.aqap.banks.boc.net.service.BocNetUtils;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.banks.boc.net.service.payment.individual.IndividualQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFieldConstants;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IndividualPayImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IndividualQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "b2e0061";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u79c1\u652f\u4ed8", (String)"IndividualPayImpl_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.getIndividual() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest request) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            List paymentInfos = request.getPaymentInfos();
            if (BankBusinessConfig.isAddKDFlagToPay()) {
                PaymentUtil.setKdFlagIDByBankDetailSeqID((List)paymentInfos);
            }
            String token = la.getToken();
            String string = this.pack2Individual(paymentInfos.toArray(new PaymentInfo[paymentInfos.size()]), token);
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    private String pack2Individual(PaymentInfo[] paymentInfos, String token) {
        Element root = BocNetUtils.createRoot();
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
        JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
        JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
        JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
        JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0061");
        JDomUtils.addChild((Element)head, (String)"token", (String)token);
        Element trans = JDomUtils.addChild((Element)root, (String)"trans");
        Element action = JDomUtils.addChild((Element)trans, (String)"trn-b2e0061-rq");
        if (BankBusinessConfig.isPaymetByAuthorized()) {
            JDomUtils.addChild((Element)action, (String)"transtype", (String)"1");
        } else {
            JDomUtils.addChild((Element)action, (String)"transtype", (String)"");
        }
        for (int i = 0; i < paymentInfos.length; ++i) {
            PaymentInfo info = paymentInfos[i];
            Element record = JDomUtils.addChild((Element)action, (String)"b2e0061-rq");
            info.setBankRefID(BocNetUtils.getBankDetailSeqId(info));
            JDomUtils.addChild((Element)record, (String)"insid", (String)BocNetUtils.getInsid(info));
            PaymentInfoSysFiled.set((PaymentInfo)info, (String)PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID, (String)BocNetUtils.getSeqIdFromInsid(info.getBankDetailSeqID()));
            JDomUtils.addChild((Element)record, (String)"obssid", (String)"");
            Element fractn = JDomUtils.addChild((Element)record, (String)"fractn");
            JDomUtils.addChild((Element)fractn, (String)"fribkn", (String)info.getAreaCode());
            JDomUtils.addChild((Element)fractn, (String)"actacn", (String)info.getAccNo());
            JDomUtils.addChild((Element)fractn, (String)"actnam", (String)info.getAccName());
            Element toactn = JDomUtils.addChild((Element)record, (String)"toactn");
            if (info.getSameBank().booleanValue()) {
                JDomUtils.addChild((Element)toactn, (String)"toibkn", (String)info.getIncomeAreaCode());
            } else {
                JDomUtils.addChild((Element)toactn, (String)"toibkn", (String)info.getIncomeCnaps());
            }
            String oppAcntNo = info.getIncomeAccNo();
            boolean isSameBankPay = info.getSameBank();
            if (isSameBankPay) {
                if (oppAcntNo.length() == 19 || oppAcntNo.length() == 16) {
                    JDomUtils.addChild((Element)toactn, (String)"acttyp", (String)"119");
                } else if (oppAcntNo.trim().length() <= 18 && oppAcntNo.trim().length() >= 12) {
                    JDomUtils.addChild((Element)toactn, (String)"acttyp", (String)"188");
                } else {
                    JDomUtils.addChild((Element)toactn, (String)"acttyp", (String)"");
                }
            } else {
                JDomUtils.addChild((Element)toactn, (String)"acttyp", (String)"");
            }
            JDomUtils.addChild((Element)toactn, (String)"actacn", (String)info.getIncomeAccNo());
            JDomUtils.addChild((Element)toactn, (String)"toname", (String)info.getIncomeAccName());
            JDomUtils.addChild((Element)toactn, (String)"tobknm", (String)info.getIncomeBankName());
            JDomUtils.addChild((Element)toactn, (String)"toaddr", (String)info.getIncomeBankAddress());
            JDomUtils.addChild((Element)record, (String)"trnamt", (String)info.getAmount().toString());
            JDomUtils.addChild((Element)record, (String)"trncur", (String)info.getCurrency());
            JDomUtils.addChild((Element)record, (String)"priolv", (String)(info.getUrgent() != false ? "1" : "0"));
            JDomUtils.addChild((Element)record, (String)"cuspriolv", (String)(info.getUrgent() != false ? "1" : "0"));
            JDomUtils.addChild((Element)record, (String)"furinfo", (String)PaymentUtil.substringChinese((boolean)true, (String)info.getExplanation(), (int)200, (String)RequestContextUtils.getCharset()));
            JDomUtils.addChild((Element)record, (String)"trfdate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
            JDomUtils.addChild((Element)record, (String)"comacn", (String)"");
            JDomUtils.addChild((Element)record, (String)"bocflag", (String)(true == isSameBankPay ? "1" : "0"));
        }
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        String trnscode = null;
        trnscode = "b2e0061";
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        boolean isError = Parser.parserB2eError(root, paymentInfos);
        if (isError) {
            return new EBBankPayResponse(paymentInfos);
        }
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-" + trnscode + "-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if ("1011".equalsIgnoreCase(rspcod)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)rspcod, (String)rspmsg);
            return new EBBankPayResponse(paymentInfos);
        }
        if (!"B001".equalsIgnoreCase(rspcod)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e0d\u786e\u5b9a\u72b6\u6001\u7801\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"IndividualPayImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)rspcod, (String)rspmsg);
            return new EBBankPayResponse(paymentInfos);
        }
        List list = trn.getChildren(trnscode + "-rs");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Element rs = (Element)list.get(i);
            String insid = rs.getChildTextTrim("insid");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)BocNetUtils.getSeqIdFromInsid(insid));
            if (null == info) continue;
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            if ("B001".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if ("1014".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if (FailCode.getInstance().isFail(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"IndividualPayImpl_2", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

