/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.opa.services.payment;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.opa.utils.CommonUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public EBBankPayResponse doBiz(BankPayRequest request) {
        EBBankPayResponse response;
        try {
            String requestStr = this.pack(request);
            Preconditions.checkNotNull((Object)requestStr, (Object)ResManager.loadKDString((String)"\u6253\u5305\u540e\u5f85\u53d1\u9001\u7684\u6570\u636e\u4e0d\u80fd\u4e3anull", (String)"QueryPaymentImpl_0", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]));
            String responseStr = new CommonUtil().sendToBank(this.getBizCode(), requestStr);
            response = this.parse(request, responseStr);
        }
        catch (Exception var24) {
            String errorMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u51fa\u73b0\u5f02\u5e38", (String)"QueryPaymentImpl_1", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((String)var24.getMessage())) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u51fa\u73b0\u5f02\u5e38:%s", (String)"QueryPaymentImpl_2", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]), var24.getMessage());
            }
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)var24);
        }
        return response;
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("serialNo", (Object)Sequence.gen18Sequence());
        jsonObject.put("cid", (Object)EBContext.getContext().getParameter().getBankParameter("cust_no"));
        jsonObject.put("trnSerialNo", (Object)paymentInfo.getBankBatchSeqID());
        return jsonObject.toJSONString();
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        String code = jsonObject.getString("code");
        String msg = jsonObject.getString("msg");
        if (!"0".equals(code)) {
            EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)code, (String)msg);
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        String trnStatus = jsonObject.getString("trnStatus");
        String trnMessage = jsonObject.getString("trnMessage");
        if ("PAYOUT".equals(trnStatus)) {
            EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.SUCCESS, (String)"", (String)trnStatus, (String)trnMessage);
        } else if ("AUDITING".equals(trnStatus) || "AUDITED".equals(trnStatus) || "WAIT_FOR_AUDIT".equals(trnStatus) || "PROCESSING".equals(trnStatus) || "SEND_BACK".equals(trnStatus)) {
            EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.SUBMITED, (String)"", (String)trnStatus, (String)trnMessage);
        } else if ("FAIL".equals(trnStatus) || "CANCEL".equals(trnStatus) || "EXPIRED".equals(trnStatus)) {
            EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.FAIL, (String)"", (String)trnStatus, (String)trnMessage);
        } else {
            EBGBusinessUtils.setPaymentState((List)request.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)trnStatus, (String)trnMessage);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "/api/dcfirmSAAS/queryPayOrder";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5355\u7b14\u8f6c\u8d26\u7ed3\u679c", (String)"QueryPaymentImpl_3", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]);
    }
}

