/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.opa.utils;

import com.cib.fintech.dfp.open.sdk.OpenSdk;
import com.cib.fintech.dfp.open.sdk.config.Configure;
import com.cib.fintech.dfp.open.sdk.config.KeyConfigure;
import com.cib.fintech.dfp.open.sdk.enums.KeySignTypeEnum;
import com.cib.fintech.dfp.open.sdk.enums.ReqMethodEnum;
import com.cib.fintech.dfp.open.sdk.enums.RespSignAlgorithmEnum;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.opa.CibOpaConstants;
import kd.ebg.aqap.banks.cib.opa.utils.CIBCertificateUtil;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class CommonUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CommonUtil.class);

    public void keyConfigureInit() {
        String keyId = CibOpaConstants.getKeyID();
        Map keyConfigures = Configure.getKeyConfigures();
        KeyConfigure keyConfigure = new KeyConfigure();
        keyConfigure.setKeyId(keyId);
        keyConfigure.setPriKey("AK7JUorRStFAwM1+BXiHefwmCOZXjVU42b6Oa5JFf5Y7");
        keyConfigure.setKeySignType(KeySignTypeEnum.CFCAFILECERTSM);
        keyConfigure.setRespSignSwitch(false);
        keyConfigure.setRespSignAlgorithm(RespSignAlgorithmEnum.SM3WITHSM2);
        String publicCertPath = CIBCertificateUtil.getPublicFileDir();
        CertInfo privateCertInfo = CIBCertificateUtil.getPrivateCertInfo();
        if (privateCertInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u4e0a\u4f20\u4e86\u79c1\u94a5\u6587\u4ef6", (String)"CommonUtil_0", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]));
        }
        String privateCertPwd = privateCertInfo.getCertPassword();
        String privateCertPath = CIBCertificateUtil.getPrivateFileDir(privateCertInfo);
        keyConfigure.setSslCertFilePath(publicCertPath);
        keyConfigure.setCertFilePath(privateCertPath);
        keyConfigure.setCertPassword(privateCertPwd);
        keyConfigures.put(keyId, keyConfigure);
        Configure.setKeyConfigures((Map)keyConfigures);
        if ("prod".equals(System.getProperty("ebg.server.env"))) {
            Configure.setDevEnv((boolean)false);
        } else {
            Configure.setDevUrl((String)"https://open.dev.cibfintech.com");
            Configure.setDevUrlSM((String)"https://open.dev.cibfintech.com");
            Configure.setDevEnv((boolean)true);
        }
    }

    public String sendToBank(String transCode, String requestStr) {
        logger.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + requestStr);
        this.keyConfigureInit();
        String result = OpenSdk.gatewayJsonWithKeyId((String)transCode, (ReqMethodEnum)ReqMethodEnum.POST, null, null, (String)requestStr, (String)CibOpaConstants.getKeyID());
        logger.info("\u54cd\u5e94\u62a5\u6587\uff1a" + result);
        return result;
    }
}

