/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.h2h.services.handler;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractACKHandler;
import kd.ebg.aqap.proxy.oversea.utils.OverseaDBHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class DBSSG_DC_PAY_ACK_Handler
extends AbstractACKHandler {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DBSSG_DC_PAY_ACK_Handler.class);

    protected List<PaymentInfo> processFile(File file) {
        List<Object> list = Lists.newArrayList();
        try {
            if (this.isACK1(file.getName())) {
                list = this.processFileLevelACK1(file);
            } else if (this.isACK2(file.getName())) {
                list = this.processFileLevelACK2(file);
            } else if (this.isTransactionLevelACK3(file.getName())) {
                list = this.processTransactionLevelACK3(file);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u4ed8\u6b3e\u5e94\u7b54\u62a5\u544a[%1$s]\u51fa\u9519:%2$s\u3002", (String)"DBSSG_DC_PAY_ACK_Handler_3", (String)"ebg-aqap-banks-dbs-h2h", (Object[])new Object[0]), file.getName(), e.getMessage()), (Throwable)e);
        }
        return list;
    }

    private List<PaymentInfo> processTransactionLevelACK3(File file) throws IOException {
        List<String> content = this.readFileContent(file);
        ArrayList paymentInfos = Lists.newArrayList();
        for (String line : content) {
            if (!line.startsWith("DATA")) continue;
            String[] split = line.split(",", -1);
            String bankDetailSeqId = split[5];
            String status = split[11];
            String msg = split[12];
            PaymentInfo paymentInfo = OverseaDBHelper.getPaymentInfoByBankDetailSeqId((String)bankDetailSeqId);
            if (paymentInfo == null) continue;
            if (status.equalsIgnoreCase("ACCP") || status.equalsIgnoreCase("ACWC")) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"DBSSG_DC_PAY_ACK_Handler_0", (String)"ebg-aqap-banks-dbs-h2h", (Object[])new Object[0]), (String)status, (String)msg);
            } else if (status.equalsIgnoreCase("RJCT")) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"DBSSG_DC_PAY_ACK_Handler_1", (String)"ebg-aqap-banks-dbs-h2h", (Object[])new Object[0]), (String)status, (String)msg);
            }
            paymentInfos.add(paymentInfo);
        }
        return paymentInfos;
    }

    private List<PaymentInfo> processFileLevelACK2(File file) throws IOException {
        List<String> content = this.readFileContent(file);
        ArrayList paymentInfos = Lists.newArrayList();
        for (String line : content) {
            if (!line.startsWith("DATA")) continue;
            String[] split = line.split(",", -1);
            String bankDetailSeqId = split[5];
            String status = split[11];
            String msg = split[12];
            PaymentInfo paymentInfo = OverseaDBHelper.getPaymentInfoByBankDetailSeqId((String)bankDetailSeqId);
            if (paymentInfo == null) continue;
            if (status.equalsIgnoreCase("ACCP") || status.equalsIgnoreCase("ACWC")) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"DBSSG_DC_PAY_ACK_Handler_2", (String)"ebg-aqap-banks-dbs-h2h", (Object[])new Object[0]), (String)status, (String)msg);
            } else if (status.equalsIgnoreCase("RJCT")) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"DBSSG_DC_PAY_ACK_Handler_1", (String)"ebg-aqap-banks-dbs-h2h", (Object[])new Object[0]), (String)status, (String)msg);
            }
            paymentInfos.add(paymentInfo);
        }
        return paymentInfos;
    }

    private List<PaymentInfo> processFileLevelACK1(File file) throws IOException {
        List<String> content = this.readFileContent(file);
        List paymentInfos = Lists.newArrayList();
        for (String line : content) {
            if (!line.startsWith("HEADER")) continue;
            String[] split = line.split(",", -1);
            String bankBatchSeqId = split[4];
            String groupStatus = split[9];
            String msg = split[10];
            paymentInfos = OverseaDBHelper.getPaymentInfoByBatchId((String)bankBatchSeqId);
            if (!CollectionUtil.isNotEmpty((Collection)paymentInfos)) continue;
            if (groupStatus.equalsIgnoreCase("ACTC")) {
                EBGBusinessUtils.setPaymentStateWithoutBatchSizeCheck((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"DBSSG_DC_PAY_ACK_Handler_2", (String)"ebg-aqap-banks-dbs-h2h", (Object[])new Object[0]), (String)groupStatus, (String)msg);
                continue;
            }
            if (!groupStatus.equalsIgnoreCase("RJCT")) continue;
            EBGBusinessUtils.setPaymentStateWithoutBatchSizeCheck((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"DBSSG_DC_PAY_ACK_Handler_1", (String)"ebg-aqap-banks-dbs-h2h", (Object[])new Object[0]), (String)groupStatus, (String)msg);
        }
        return paymentInfos;
    }

    private List<String> readFileContent(File file) throws IOException {
        ArrayList content = Lists.newArrayList();
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            try (BufferedReader reader = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = reader.readLine()) != null) {
                    content.add(line);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6\u6587\u4ef6" + file.getName() + "\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        return content;
    }

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    public boolean isNeedToProcessFile(String fileName) {
        return this.isACK1(fileName) || this.isACK2(fileName) || this.isTransactionLevelACK3(fileName);
    }

    private boolean isACK1(String fileName) {
        return fileName.contains("ACK1");
    }

    private boolean isACK2(String fileName) {
        return fileName.contains("ACK2");
    }

    private boolean isTransactionLevelACK3(String fileName) {
        return fileName.contains("ACK3");
    }
}

