/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.h2h.services.payments.bpy;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.banks.dbs.h2h.BankBusinessConfig;
import kd.ebg.aqap.banks.dbs.h2h.DbsH2HMetaDataImpl;
import kd.ebg.aqap.banks.dbs.h2h.services.payments.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.utils.PaymentAmountUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.aqap.proxy.oversea.bank.AbstractOverseaPayImpl;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PayImpl
extends AbstractOverseaPayImpl
implements IPay {
    protected String getPayFileName(BankPayRequest bankPayRequest) {
        String subOrgId;
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        StringBuilder sb = new StringBuilder();
        String payFileName = RequestContextUtils.getBankParameterValue((String)DbsH2HMetaDataImpl.pay_file_name);
        String orgId = RequestContextUtils.getBankParameterValue((String)DbsH2HMetaDataImpl.organization_id);
        if (StringUtils.isNotEmpty((String)payFileName)) {
            sb.append(payFileName).append(".");
        }
        if (StringUtils.isEmpty((String)(subOrgId = BankBusinessConfig.getSubOrgId(paymentInfo.getAccNo())))) {
            subOrgId = orgId;
        }
        sb.append(orgId).append(".").append(subOrgId).append(".").append(paymentInfo.getBankBatchSeqID()).append(".csv.DBSSSGSG.pgp");
        return sb.toString();
    }

    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String subOrgId = BankBusinessConfig.getSubOrgId(((PaymentInfo)paymentInfos.get(0)).getAccNo());
        StringBuilder request = new StringBuilder();
        StringBuilder header = new StringBuilder();
        header.append("HEADER").append(",").append(LocalDate.now().format(DateTimeFormatter.ofPattern("ddMMyyyy"))).append(",").append(StringUtils.isEmpty((String)subOrgId) ? RequestContextUtils.getBankParameterValue((String)DbsH2HMetaDataImpl.organization_id) : subOrgId).append(",").append(RequestContextUtils.getBankParameterValue((String)DbsH2HMetaDataImpl.organization_name)).append("\r\n");
        StringBuilder details = new StringBuilder();
        String batchId = Sequence.getAutoincrementNumber((int)5);
        for (PaymentInfo paymentInfo : paymentInfos) {
            int i;
            details.append("PAYMENT").append(",").append("BPY").append(",").append(paymentInfo.getAccNo()).append(",").append(paymentInfo.getCurrency()).append(",").append(paymentInfo.getBankBatchSeqID()).append(",").append(paymentInfo.getPayCurrency()).append(",").append(batchId).append(",").append(LocalDate.now().format(DateTimeFormatter.ofPattern("ddMMyyyy"))).append(",");
            details.append(",").append(",").append(paymentInfo.getIncomeAccName()).append(",").append(",").append(",").append(",").append(",").append(paymentInfo.getIncomeAccNo()).append(",").append(",").append(",").append(",").append(",").append(paymentInfo.getIncomeSwiftCode()).append(",").append(",").append(",").append(",").append(",").append(",").append(",").append(BigDecimalHelper.plain2((BigDecimal)paymentInfo.getActualAmount())).append(",").append(",").append(",").append(",").append(",").append("20").append(",").append(paymentInfo.getBankDetailSeqID()).append(",").append(",").append(paymentInfo.getExplanation()).append(",").append(",").append(",").append(",").append(",").append(",").append(",").append(paymentInfo.getBusinessTypeCode()).append(",").append(",").append(StringUtils.isNotEmpty((String)paymentInfo.getEmails()) ? "E" : "").append(",").append(",").append(",").append(",").append(",").append(",").append(",").append(",").append(",");
            ArrayList<String> lists = new ArrayList<String>(5);
            if (StringUtils.isNotEmpty((String)paymentInfo.getEmails())) {
                String[] emails;
                for (String email : emails = paymentInfo.getEmails().split(";")) {
                    lists.add(email);
                }
            }
            for (i = lists.size(); i < 5; ++i) {
                lists.add("");
            }
            for (i = 0; i < 5; ++i) {
                details.append((String)lists.get(i)).append(",");
            }
            details.append(",").append(",").append(",").append(",").append(",").append(paymentInfo.getInvoiceNo()).append(",").append(",").append(",").append(",");
            details.append("\r\n");
        }
        StringBuilder trailer = new StringBuilder();
        trailer.append("TRAILER").append(",").append(paymentInfos.size()).append(",").append(BigDecimalHelper.plain2((BigDecimal)PaymentAmountUtils.getTotalActualAmount((List)paymentInfos)));
        request.append((CharSequence)header).append((CharSequence)details).append((CharSequence)trailer);
        return request.toString();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "BPY";
    }

    public String getBizDesc() {
        return "Bulk Payment";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "overseaPay".equalsIgnoreCase(paymentInfo.getSubBizType()) && "BPY".equalsIgnoreCase(paymentInfo.getUseCN());
    }
}

