/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jshb.dc.utils;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.string.StringUtils;

public class TCommon {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(TCommon.class);

    public static String createCommonMsg(String xml) {
        int msglen = TCommon.getLength(xml);
        int len = String.valueOf(msglen).length();
        String result = String.valueOf(len);
        StringBuilder buffer = new StringBuilder();
        while (10 - len > 0) {
            buffer.append("0");
            ++len;
        }
        buffer.append(msglen);
        result = buffer.toString();
        return result + "00" + xml;
    }

    public static int getLength(String str) {
        String encoding = RequestContextUtils.getCharset();
        try {
            int length = str.getBytes(encoding).length;
            return length + 2;
        }
        catch (Exception e) {
            log.error(str + ", encoding:" + encoding, (Throwable)e);
            return 0;
        }
    }

    public static int getLengthGBK(String str) {
        try {
            int length = str.getBytes("GBK").length;
            return length + 2;
        }
        catch (Exception e) {
            log.error(str + ", encoding:GBK", (Throwable)e);
            return 0;
        }
    }

    public static String formatLen(String msgLen, int len) {
        try {
            return StringFormater.formatLen((String)msgLen, (int)len, (boolean)true, (char)'0', (String)TCommon.getEncoding());
        }
        catch (Exception e) {
            log.error("\u9519\u8bef", (Throwable)e);
            return "";
        }
    }

    public static String getEncoding() {
        return RequestContextUtils.getBankParameterValue((String)"charset");
    }

    private static byte[] read(DataInputStream dis, int length) {
        byte[] bytes = new byte[length];
        try {
            int result = dis.read(bytes);
            if (result - length != 0) {
                log.info("\u9519\u8bef" + length + ",\u9519\u8bef" + result);
            }
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u9519\u8bef,IOException %1$s", (String)"TCommon_2", (String)"ebg-aqap-banks-jshb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return bytes;
    }

    private static String read2String(DataInputStream dis, int length, String encoding) {
        try {
            String str = new String(TCommon.read(dis, length), encoding);
            str = StringUtils.isEmpty((String)str) ? "" : str.trim();
            return str;
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u9519\u8bef %1$s\u3002", (String)"TCommon_3", (String)"ebg-aqap-banks-jshb-dc", (Object[])new Object[0]), encoding), (Throwable)e);
        }
    }

    public static String recvMessage(InputStream inputStream) {
        String encoding = RequestContextUtils.getCharset();
        try {
            DataInputStream dis = new DataInputStream(inputStream);
            String length = TCommon.read2String(dis, 10, encoding);
            int len = Integer.parseInt(length);
            String str = TCommon.read2String(dis, 2, encoding);
            String xmlString = TCommon.read2String(dis, len - 2, encoding);
            log.info(length + ", " + str + "," + xmlString);
            return xmlString;
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static String parseRecvMsg(String input) {
        if (!StringUtils.isEmpty((String)input)) {
            return input.substring(12);
        }
        return "";
    }
}

