/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdcb.cms.service.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdcb.cms.utils.Packer;
import kd.ebg.aqap.banks.cdcb.cms.utils.Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    public String pack(BankDetailRequest bankDetailRequest) {
        String currentPage = this.getCurrentPage();
        if (StringUtils.isEmpty((String)currentPage) || "0".equals(currentPage)) {
            this.setCurrentPage("1");
        }
        Element ap = Packer.creatHead("03020101A0007", Sequence.gen18Sequence());
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"currency", (String)bankDetailRequest.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"startDate", (String)LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getStartDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getEndDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"start", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"size", (String)"20");
        String request = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return Packer.createCommonMsg(request);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String rspStr) {
        Element element = Parser.getResponseElement(rspStr);
        Parser.resSuccessCheck(element);
        Element body = element.getChild("body");
        if (DetailImpl.isLastPage(body)) {
            this.setLastPage(true);
        } else {
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 20);
        }
        Element array = body.getChild("array");
        List dtoList = array.getChildren("dto");
        BankAcnt bankAcnt = request.getAcnt();
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        for (Element element1 : dtoList) {
            String balance;
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setAccNo(bankAcnt.getAccNo());
            detailInfo.setAccName(bankAcnt.getAccName());
            detailInfo.setBankName(bankAcnt.getBankName());
            detailInfo.setBankVersionID(bankAcnt.getBankVersionId());
            detailInfo.setBankLoginID(bankAcnt.getBankLoginId());
            String drcrFlag = element1.getChildText("drcrFlag");
            String amt = element1.getChildText("amt");
            if ("C".equalsIgnoreCase(drcrFlag)) {
                detailInfo.setCreditAmount(new BigDecimal(amt));
                detailInfo.setDebitAmount(BigDecimal.valueOf(0.0));
            }
            if ("D".equalsIgnoreCase(drcrFlag)) {
                detailInfo.setDebitAmount(new BigDecimal(amt));
                detailInfo.setCreditAmount(BigDecimal.valueOf(0.0));
            }
            String tranDate = element1.getChildText("trDate");
            String tranTime = element1.getChildText("trTime");
            if (StringUtils.isEmpty((String)tranTime)) {
                tranTime = "000000";
            }
            if (StringUtils.isNotEmpty((String)tranDate)) {
                detailInfo.setTransDate(LocalDateUtil.parserDate((String)tranDate));
                detailInfo.setTransTime(LocalDateUtil.parseDateTime((String)(tranDate + tranTime)));
            }
            detailInfo.setBalance(StringUtils.isEmpty((String)(balance = element1.getChildText("balance"))) ? BigDecimal.valueOf(0.0) : new BigDecimal(balance));
            detailInfo.setOppAccNo(element1.getChildText("oppAcctNo"));
            detailInfo.setOppAccName(element1.getChildText("oppAcctName"));
            detailInfo.setOppBankName(element1.getChildText("oppBankName"));
            String summary = element1.getChildText("summary");
            detailInfo.setExplanation(summary);
            detailInfo.setCurrency(element1.getChildText("currency"));
            if (!StringUtils.isEmpty((String)summary) && summary.contains("KD")) {
                String kdRetFlag = summary.substring(0, summary.indexOf("KD"));
                DetailSysFiled.set((DetailInfo)detailInfo, (String)"KDRetFlag", (String)kdRetFlag);
            }
            JSONObject receiptJson = new JSONObject();
            receiptJson.put("accNo", (Object)bankAcnt.getAccNo());
            receiptJson.put("transDate", (Object)tranDate);
            receiptJson.put("hostSerialNo", (Object)element1.getChildText("hostSerialNo"));
            detailInfo.setJsonMap(receiptJson.toJSONString());
            String rNo = MatchRule.getInstance().getReceiptNo(bankAcnt.getAccNo(), tranDate, receiptJson.toJSONString());
            detailInfo.setReceiptNo(rNo);
            detailList.add(detailInfo);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "03020101A0007";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_0", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }

    public static boolean isLastPage(Element body) throws EBServiceException {
        String total = body.getChildText("total");
        int totalCount = StrUtil.isNotBlank((CharSequence)total) ? Integer.parseInt(total) : 0;
        String start = body.getChildText("start");
        int startCount = StrUtil.isNotBlank((CharSequence)start) ? Integer.parseInt(start) : 0;
        int sizeCount = 20;
        if (totalCount <= sizeCount) {
            return true;
        }
        if (body.getChild("array") == null) {
            return true;
        }
        return startCount + sizeCount - 1 >= totalCount;
    }
}

