/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdcb.cms.service.payment.sameBank;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdcb.cms.BankBusinessConfig;
import kd.ebg.aqap.banks.cdcb.cms.service.payment.sameBank.QueryPayImpl;
import kd.ebg.aqap.banks.cdcb.cms.utils.Packer;
import kd.ebg.aqap.banks.cdcb.cms.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element ap = Packer.creatHead("03020104B0210", paymentInfo.getBankBatchSeqId());
        Element body = JDomUtils.addChild((Element)ap, (String)"body");
        JDomUtils.addChild((Element)body, (String)"currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"payAcctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"payAcctName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"amt", (String)paymentInfo.getAmount().setScale(2, 5).toString());
        JDomUtils.addChild((Element)body, (String)"rcvAcctNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcvAcctName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"tfrType", (String)"1");
        String summary = paymentInfo.getExplanation();
        if (StringUtils.isEmpty((String)summary)) {
            summary = paymentInfo.getUseCn();
        }
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            summary = paymentInfo.getBankDetailSeqId() + "KD" + summary;
            PaymentUtil.setKdFlagID((PaymentInfo)paymentInfo, (String)paymentInfo.getBankDetailSeqId());
        }
        JDomUtils.addChild((Element)body, (String)"summary", (String)(summary.length() > 256 ? summary.substring(0, 256) : summary));
        String request = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return Packer.createCommonMsg(request);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element element = Parser.getResponseElement(rspStr);
        Element head = element.getChild("head");
        Element body = element.getChild("body");
        BankResponse bankResponse = Parser.parseBankResponse(head);
        if ("0_0000".equals(bankResponse.getResponseCode())) {
            String stat = JDomUtils.getChildText((Element)body, (String)"stat");
            if ("S".equals(stat)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u6210\u529f", (String)"PayImpl_0", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]), (String)stat, (String)bankResponse.getResponseMessage());
            } else if ("F".equals(stat)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u5931\u8d25", (String)"PayImpl_1", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]), (String)stat, (String)bankResponse.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"PayImpl_2", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]), (String)stat, (String)bankResponse.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u5931\u8d25", (String)"PayImpl_1", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "03020104B0210";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26", (String)"PayImpl_4", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]);
    }
}

