/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdcb.cms.utils;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Parser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(Parser.class);

    public static Element getResponseElement(String response) {
        String resData = Parser.parseRecvMsg(response);
        if (StringUtils.isEmpty((String)resData)) {
            logger.error("=======\u8fd4\u56de\u7684\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a=======");
            throw new EBServiceException(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a", (String)"Parser_0", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]));
        }
        String encoding = RequestContextUtils.getCharset();
        Element element = JDomUtils.string2Root((String)resData, (String)encoding);
        return element;
    }

    public static String parseRecvMsg(String input) {
        return !StringUtils.isEmpty((String)input) ? input.substring(12) : "";
    }

    public static BankResponse parseBankResponse(Element head) {
        BankResponse response = new BankResponse();
        String succFlag = head.getChildTextTrim("succ_flag");
        String retCode = head.getChildTextTrim("ret_code");
        String retInfo = head.getChildTextTrim("ret_info");
        String extInfo = head.getChildTextTrim("ext_info");
        String responseMessage = retInfo;
        if (!StringUtils.isEmpty((String)extInfo)) {
            responseMessage = responseMessage + "_" + extInfo;
        }
        response.setResponseCode(succFlag + "_" + retCode);
        response.setResponseMessage(responseMessage);
        return response;
    }

    public static void resSuccessCheck(Element element) {
        Element head = element.getChild("head");
        BankResponse bankResponse = Parser.parseBankResponse(head);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            logger.error("\u54cd\u5e94\u5931\u8d25====retCode\uff1a" + bankResponse.getResponseCode() + "===\u5f02\u5e38\u4fe1\u606f:" + bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u54cd\u5e94\u5931\u8d25%1$s", (String)"Parser_1", (String)"ebg-aqap-banks-cdcb-cms", (Object[])new Object[0]), bankResponse.getResponseMessage()));
        }
        logger.info("\u54cd\u5e94\u6210\u529f====retCode\uff1a" + bankResponse.getResponseCode() + "===\u8fd4\u56de\u4fe1\u606f:" + bankResponse.getResponseMessage());
    }
}

