/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hbnxs.dc.services.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HBNXS_DCFileUtils
extends AbstractImpl {
    public static final String BIZ_SUCCESS = "BIZ_SUCCESS";
    private static String uploadFile = "uploadFile";
    private static String downloadFile = "downloadFile";
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HBNXS_DCFileUtils.class);

    public static String sendAndRecv(String url, String param) {
        String ip = RequestContextUtils.getBankParameterValue((String)"frontProxy_ip");
        if (null == ip || "".equals(ip)) {
            ip = RequestContextUtils.getBankParameterValue((String)"ip");
        }
        String portStr = RequestContextUtils.getBankParameterValue((String)"frontProxy_port");
        String timeOutStr = RequestContextUtils.getBankParameterValue((String)"frontProxy_timeOut");
        int timeOut = Integer.parseInt(timeOutStr);
        if (timeOut == 0) {
            timeOut = 5;
        }
        String result = "";
        try {
            URL realUrl = new URL("http://" + ip + ":" + portStr + url);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setConnectTimeout(60000 * timeOut);
            try (OutputStream outputStream = conn.getOutputStream();
                 PrintWriter out = new PrintWriter(outputStream);){
                out.print(param);
                out.flush();
                try (InputStream inputStream = conn.getInputStream();){
                    result = IOUtils.readFully((InputStream)inputStream, (String)"UTF-8");
                }
            }
        }
        catch (Exception e) {
            EBExceiptionUtil.serviceException((Throwable)e);
        }
        return result;
    }

    public String downloadFile(String fileName, String filePath) {
        try {
            String rqstStr = this.packDownlaodFileXML(fileName, filePath);
            logger.info("\u4ee3\u7406\u7a0b\u5e8f\u53d1\u9001\u7684\u6570\u636e\u4e3a" + rqstStr);
            String rspStr = HBNXS_DCFileUtils.sendAndRecv("/ent/transcode=b2e005111.do", rqstStr);
            return this.parseDownlaodFileXML(rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    private String packDownlaodFileXML(String fileName, String filePath) {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = this.createHead(downloadFile);
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"fileName", (String)fileName);
        JDomUtils.addChild((Element)reqPara, (String)"filePath", (String)filePath);
        return JDomUtils.root2String((Element)simulator, (String)"UTF-8");
    }

    private String parseDownlaodFileXML(String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)"GBK");
        BankResponse rsp = this.parseHeader(root);
        if (!BIZ_SUCCESS.equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38 %1$s\uff0c%2$s\u3002", (String)"HBNXS_DCFileUtils_8", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        Element status = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"HBNXS_DCFileUtils_1", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if (!BIZ_SUCCESS.equals(ReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25 %1$s,%2$s", (String)"HBNXS_DCFileUtils_9", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
        String fileContent = JDomUtils.getChildTextTrim((Element)rspPara, (String)"fileContent");
        return fileContent;
    }

    public Element createHead(String bizType) {
        return this.createHead(bizType, Sequence.genSequence());
    }

    public Element createHead(String bizType, String seqno) {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)DateTimeUtils.formatDate((Date)new Date()));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)DateTimeUtils.formatTime((Date)new Date()));
        JDomUtils.addChild((Element)head, (String)"bizType", (String)bizType);
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqno);
        return head;
    }

    public BankResponse parseHeader(Element root) {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"rspcode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"HBNXS_DCFileUtils_5", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }
}

