/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.arcu.dc.services.payment.salary;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.arcu.dc.services.payment.common.CommonParser;
import kd.ebg.aqap.banks.arcu.dc.services.payment.salary.QrySalPaymentImpl;
import kd.ebg.aqap.banks.arcu.dc.services.utils.ARCU_DC_Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalPaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QrySalPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = ARCU_DC_Packer.getCommonHeader("B2EAgentPayeeSalary", paymentInfo.getBankBatchSeqId(), paymentInfo.getRequestTime());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        String busiNo = RequestContextUtils.getBankParameterValue((String)"BusiNo");
        if (StringUtils.isEmpty((String)busiNo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u534f\u8bae\u53f7\u5fc5\u586b\uff0c\u8bf7\u5728\"\u67e5\u8be2\u4e0e\u652f\u4ed8\"-\"\u94f6\u4f01\u8fde\u63a5\u914d\u7f6e\"-\"\u94f6\u4f01\u8fde\u63a5\u901a\u9053\u914d\u7f6e\"-\"\u7f51\u94f6\u767b\u5f55\u914d\u7f6e\"\u5185\u914d\u7f6e\u4ee3\u53d1\u534f\u8bae\u53f7\uff0c\u518d\u63d0\u4ea4\u67e5\u8be2\u3002", (String)"SalPaymentImpl_0", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]));
        }
        this.setBusNo(paymentInfos, busiNo);
        JDomUtils.addChild((Element)body, (String)"BusiNo", (String)busiNo);
        JDomUtils.addChild((Element)body, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PayerAcName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"Currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"TotalCount", (String)(paymentInfos.size() + ""));
        JDomUtils.addChild((Element)body, (String)"Amount", (String)paymentInfo.getTotalAmount().toString());
        Element list = JDomUtils.addChild((Element)body, (String)"List");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            Element map = JDomUtils.addChild((Element)list, (String)"Map");
            paymentInfo = (PaymentInfo)paymentInfos.get(i);
            JDomUtils.addChild((Element)map, (String)"EmployeeNo", (String)(i + ""));
            JDomUtils.addChild((Element)map, (String)"PayeeAcNo", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)map, (String)"PayeeAcName", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)map, (String)"Amount", (String)paymentInfo.getAmount().toString());
        }
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    private void setBusNo(List<PaymentInfo> paymentInfoList, String busNo) {
        for (PaymentInfo paymentInfo : paymentInfoList) {
            paymentInfo.setBiz("BusiNo", busNo);
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        CommonParser.parserCommonInfo(paymentInfos, s);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EAgentPayeeSalary";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

