/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.opa.service.apply;

import com.alibaba.fastjson.JSONArray;
import com.bocom.api.BocomRequest;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.util.StringUtils;
import kd.ebg.aqap.banks.bocom.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.opa.request.ApplyRequest;
import kd.ebg.aqap.banks.bocom.opa.response.ApplyResponse;
import kd.ebg.aqap.banks.bocom.opa.utils.BocomOpaUtil;
import kd.ebg.aqap.business.apply.atomic.AbstractApplyImpl;
import kd.ebg.aqap.business.apply.atomic.IApply;
import kd.ebg.aqap.business.apply.bank.BankApplyRequest;
import kd.ebg.aqap.business.apply.bank.EBBankApplyResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class BocomOpaApplyImpl
extends AbstractApplyImpl
implements IApply {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BocomOpaApplyImpl.class);

    public EBBankApplyResponse doBiz(BankApplyRequest request) {
        String methodName;
        String string = methodName = "A".equals(request.getApplyType()) ? ResManager.loadKDString((String)"\u7b7e\u7ea6", (String)"BocomOpaApplyImpl_0", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u89e3\u7ea6", (String)"BocomOpaApplyImpl_1", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]);
        if (this.canDoIt()) {
            try {
                ApplyResponse response = (ApplyResponse)BocomOpaUtil.send((BocomRequest)this.getRequest(request), this.getBizCode());
                return this.parse(request, response);
            }
            catch (Exception e) {
                this.logger.error(methodName + "\u5931\u8d25", (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"%s\u5931\u8d25", (String)"BocomOpaApplyImpl_2", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]), methodName), (Throwable)e);
            }
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u9650\u6d41 \u8c03\u7528\u9891\u7387\u4e3a : %s\u6beb\u79d2", (String)"BocomOpaApplyImpl_3", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]), this.getInterval()));
    }

    private ApplyRequest getRequest(BankApplyRequest bankApplyRequest) {
        BankAcnt bankAcnt = bankApplyRequest.getAcnt();
        ApplyRequest request = new ApplyRequest();
        ApplyRequest.ApplyRequestBiz bizContent = new ApplyRequest.ApplyRequestBiz();
        bizContent.setPpasHead((ApplyRequest.ApplyRequestBiz.PpasHead)JSONArray.parseObject((String)BocomOpaUtil.getBizContentHead(), ApplyRequest.ApplyRequestBiz.PpasHead.class));
        ApplyRequest.ApplyRequestBiz.PpasBody ppasBody = new ApplyRequest.ApplyRequestBiz.PpasBody();
        bizContent.setPpasBody(ppasBody);
        ppasBody.setPlfmBsnId(BankBusinessConfig.getPlfmBsnID());
        String plfmSerNo = BocomOpaUtil.genSeqId();
        RequestContextUtils.setRunningParam((String)"plfm_ser_no", (String)plfmSerNo);
        ppasBody.setPlfmSerNo(plfmSerNo);
        ppasBody.setSignAcctNo(bankAcnt.getAccNo());
        ppasBody.setSignAcctNme(bankAcnt.getAccName());
        if ("A".equals(bankApplyRequest.getApplyType())) {
            ppasBody.setOpType("0");
            ppasBody.setOpenMode(BocomOpaUtil.getOpenMode(bankApplyRequest.getBsnStr(), "1"));
        } else {
            ppasBody.setOpType("2");
            ppasBody.setOpenMode("2222222222");
        }
        request.setBizContent(bizContent);
        return request;
    }

    public EBBankApplyResponse parse(BankApplyRequest request, ApplyResponse response) {
        if ("F".equals(response.getBizState())) {
            throw new KDException(new ErrorCode(response.getRspCode(), response.getRspMsg()), new Object[0]);
        }
        if (response.getPpasHead() != null && !StringUtils.isEmpty((Object)response.getPpasHead().getReturnMsg())) {
            throw new KDException(new ErrorCode(response.getPpasHead().getReturnCode(), response.getPpasHead().getReturnMsg()), new Object[0]);
        }
        return new EBBankApplyResponse(RequestContextUtils.getRunningParam((String)"plfm_ser_no"));
    }

    public String pack(BankApplyRequest bankApplyRequest) {
        return null;
    }

    public EBBankApplyResponse parse(BankApplyRequest bankApplyRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return "congmin_huang";
    }

    public String getBizCode() {
        return "/ppas/PPAS03001/";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u534f\u8bae\u7b7e\u7ea6\u53d8\u66f4", (String)"BocomOpaApplyImpl_5", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]);
    }
}

