/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.opa.service.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bocom.api.BocomRequest;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.banks.bocom.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.bocom.opa.request.DetailRequest;
import kd.ebg.aqap.banks.bocom.opa.response.DetailResponse;
import kd.ebg.aqap.banks.bocom.opa.utils.BocomOpaUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.EBEnviromentUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        if (this.canDoIt()) {
            try {
                DetailResponse response = (DetailResponse)BocomOpaUtil.send((BocomRequest)this.getRequest(request), this.getBizCode());
                return this.parse(request, response);
            }
            catch (Exception e) {
                this.logger.error("\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25", (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25", (String)"DetailImpl_0", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]), (Throwable)e);
            }
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u9650\u6d41 \u8c03\u7528\u9891\u7387\u4e3a : %s\u6beb\u79d2", (String)"DetailImpl_4", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]), this.getInterval()));
    }

    private DetailRequest getRequest(BankDetailRequest bankDetailRequest) {
        BankAcnt bankAcnt = bankDetailRequest.getAcnt();
        DetailRequest request = new DetailRequest();
        DetailRequest.DetailRequestBiz bizContent = new DetailRequest.DetailRequestBiz();
        DetailRequest.DetailRequestBiz.PptmBody pptmBody = new DetailRequest.DetailRequestBiz.PptmBody();
        bizContent.setPptmBody(pptmBody);
        bizContent.setPptmHead((DetailRequest.DetailRequestBiz.PptmHead)JSONArray.parseObject((String)BocomOpaUtil.getBizContentHead(), DetailRequest.DetailRequestBiz.PptmHead.class));
        pptmBody.setPlfmBsnId(BankBusinessConfig.getPlfmBsnID());
        pptmBody.setAcctNo(bankAcnt.getAccNo());
        String startDate = bankDetailRequest.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String endDate = bankDetailRequest.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        pptmBody.setBgnDt(this.convertDate(startDate));
        pptmBody.setEndDt(this.convertDate(endDate));
        String oprTp = "0";
        if (bankDetailRequest.getEndDate().isBefore(LocalDate.now().plusDays(-1L)) || bankDetailRequest.getEndDate().isAfter(LocalDate.now())) {
            oprTp = "1";
        }
        pptmBody.setOprTp(oprTp);
        pptmBody.setBsnAcptNo(bankDetailRequest.getExtData());
        pptmBody.setOffset(bankDetailRequest.getNextPageTag());
        request.setBizContent(bizContent);
        return request;
    }

    private EBBankDetailResponse parse(BankDetailRequest request, DetailResponse response) {
        if ("F".equals(response.getBizState())) {
            throw new KDException(new ErrorCode(response.getRspCode(), response.getRspMsg()), new Object[0]);
        }
        if (response.getPptmHead() != null && !StringUtils.isEmpty((String)response.getPptmHead().getReturnMsg())) {
            throw new KDException(new ErrorCode(response.getPptmHead().getReturnCode(), response.getPptmHead().getReturnMsg()), new Object[0]);
        }
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        EBBankDetailResponse result = new EBBankDetailResponse(detailList);
        DetailResponse.PptmBody body = response.getPptmBody();
        if (body == null || Integer.parseInt(body.getEnqreRecCnt()) == 0) {
            return result;
        }
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        List<DetailResponse.PptmBody.TxnDetl> list = body.getTxnDetlList();
        for (DetailResponse.PptmBody.TxnDetl txnDetl : list) {
            String drcrf;
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(txnDetl.getCcy());
            String amountStr = txnDetl.getTxnAmt();
            BigDecimal amount = BigDecimal.ZERO;
            if (!StringUtils.isEmpty((String)amountStr)) {
                amount = new BigDecimal(amountStr.trim());
            }
            if ("D".equals(drcrf = txnDetl.getIncmExpdtFlg())) {
                detail.setDebitAmount(amount);
                detail.setCreditAmount(ParserUtils.ZERO);
            } else if ("C".equals(drcrf)) {
                detail.setDebitAmount(ParserUtils.ZERO);
                detail.setCreditAmount(amount);
            }
            detail.setOppAccNo(txnDetl.getCntrpAcctNo());
            detail.setOppAccName(txnDetl.getCntrpAcctNme());
            detail.setOppBankName(txnDetl.getCntrpBankNme());
            String pscpt = txnDetl.getPscpt();
            detail.setExplanation(pscpt);
            String detailSequence = txnDetl.getJrnlNo();
            String flowSequence = txnDetl.getJrnlSeqNo();
            String dateStr = txnDetl.getTxnDt();
            String timeStr = txnDetl.getTxnTme();
            JSONObject receiptJson = new JSONObject();
            receiptJson.put("accNo", (Object)txnDetl.getAcctNo());
            receiptJson.put("transDate", (Object)dateStr);
            receiptJson.put("serialNo", (Object)(detailSequence + "@" + flowSequence));
            receiptJson.put("logNo", (Object)(detailSequence + txnDetl.getJrnlSeqNo()));
            receiptJson.put("detailSequence", (Object)detailSequence);
            receiptJson.put("Amount", (Object)amountStr);
            String receiptNo = MatchRule.getInstance().getReceiptNo(txnDetl.getAcctNo(), txnDetl.getTxnDt(), receiptJson.toJSONString());
            if (!countMap.containsKey(receiptNo)) {
                countMap.put(receiptNo, 0);
            } else {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            }
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(detailSequence);
            detail.setUseCn(txnDetl.getRemrk());
            detail.setTransDate(LocalDate.parse(dateStr, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setTransTime(LocalDateTime.parse(dateStr + timeStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            String balanceStr = txnDetl.getAvlBal();
            if (!StringUtils.isEmpty((String)balanceStr)) {
                detail.setBalance(new BigDecimal(balanceStr.trim()));
            }
            receiptJson.put("flowSequence", (Object)flowSequence);
            detail.setJsonMap(receiptJson.toJSONString());
            detailList.add(detail);
        }
        result.setNextPageTag(body.getOffset());
        result.setLastPage("0".equals(body.getEndFlg()));
        result.setExtData(body.getBsnAcptNo());
        return result;
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfoList = new ArrayList(1);
        String offset = "0";
        String bsnNo = "0";
        boolean isLastPage = false;
        while (!isLastPage) {
            request.setNextPageTag(offset);
            request.setExtData(bsnNo);
            EBBankDetailResponse response = this.doBiz(request);
            if (CollectionUtils.isEmpty((Collection)response.getDetails())) break;
            detailInfoList.addAll(response.getDetails());
            isLastPage = response.isLastPage();
            offset = response.getNextPageTag();
            bsnNo = response.getExtData();
        }
        return new EBBankDetailResponse(detailInfoList);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        LocalDate yesterday = LocalDate.now().plusDays(-1L);
        if (yesterday.isEqual(endDate)) {
            request.setStartDate(yesterday);
            request.setEndDate(yesterday);
            EBBankDetailResponse yesterdayDetail = this.detail(request);
            EBBankDetailResponse hisDetail = null;
            if (!yesterday.equals(startDate)) {
                request.setStartDate(startDate);
                request.setEndDate(yesterday.plusDays(-1L));
                hisDetail = this.detail(request);
            }
            ArrayList detailInfoList = new ArrayList(1);
            EBBankDetailResponse response = new EBBankDetailResponse(detailInfoList);
            if (yesterdayDetail != null && !CollectionUtils.isEmpty((Collection)yesterdayDetail.getDetails())) {
                detailInfoList.addAll(yesterdayDetail.getDetails());
            }
            if (hisDetail != null && !CollectionUtils.isEmpty((Collection)hisDetail.getDetails())) {
                detailInfoList.addAll(hisDetail.getDetails());
            }
            request.setStartDate(startDate);
            request.setEndDate(endDate);
            return response;
        }
        return this.detail(request);
    }

    private String convertDate(String dateStr) {
        if (EBEnviromentUtil.isProduct()) {
            return dateStr;
        }
        String testDateStr = RequestContextUtils.getBankParameterValue((String)"testServerDate");
        return StringUtils.isEmpty((String)testDateStr) ? dateStr : testDateStr;
    }

    public String pack(BankDetailRequest request) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        return null;
    }

    public String getDeveloper() {
        return "congmin_huang";
    }

    public String getBizCode() {
        return "/pptm/B2BYQFYQFU1016/";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_3", (String)"ebg-aqap-banks-bocom-opa", (Object[])new Object[0]);
    }
}

