/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.global.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.global.service.Packer;
import kd.ebg.aqap.banks.boc.net.global.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.global.service.login.LoginAccessManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    EBGLogger log = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        ArrayList balanceInfos = new ArrayList(16);
        try {
            EBBankBalanceResponse response = this.doBiz(request);
            balanceInfos.addAll(response.getBalances());
        }
        catch (EBServiceException e) {
            throw new EBServiceException((Throwable)e);
        }
        ebBankBalanceResponse.setBalances(balanceInfos);
        return ebBankBalanceResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankBalanceRequest request) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            BankAcnt acnt = request.getAcnt();
            String accNo = acnt.getAccNo();
            Element root = Packer.getHeader(token, "b2e0037");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0037-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0037-rq");
            Element account = JDomUtils.addChild((Element)rq, (String)"account");
            JDomUtils.addChild((Element)account, (String)"ibknum", (String)acnt.getAreaCode());
            JDomUtils.addChild((Element)account, (String)"actacn", (String)accNo);
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0037-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        if (!"B001".equalsIgnoreCase(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspcod, (String)rspmsg));
        }
        Element rs = trn.getChild("b2e0037-rs");
        Element another_status = rs.getChild("status");
        String another_rspcod = another_status.getChildTextTrim("rspcod");
        String another_rspmsg = another_status.getChildTextTrim("rspmsg");
        if (!"B001".equalsIgnoreCase(another_rspcod)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspcod, (String)rspmsg));
        }
        Element account = rs.getChild("account");
        String actacn = account.getChildTextTrim("actacn");
        String acntname = account.getChildTextTrim("actname");
        Element balance = rs.getChild("balance");
        String bokbal = balance.getChildTextTrim("bokbal");
        String avabal = (String)StringUtils.defaultIfBlank((CharSequence)balance.getChildTextTrim("avabal"), (CharSequence)"0.00");
        String baldat = rs.getChildTextTrim("baldat");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        BalanceInfo balanceInfo = new BalanceInfo();
        balances.add(balanceInfo);
        this.setCurrentBalance(balanceInfo, bokbal);
        this.setAvailableBalance(balanceInfo, avabal);
        BankAcnt bankAcnt = new BankAcnt();
        balanceInfo.setBankAcnt(bankAcnt);
        balanceInfo.setBankCurrency(request.getCurrency());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        bankAcnt.setAccNo(actacn);
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "b2e0037";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4eca\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-boc-net-global", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }
}

