/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.global.service.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.global.service.Packer;
import kd.ebg.aqap.banks.boc.net.global.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.global.service.login.LoginAccessManager;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    static final int PAGE_SIZE = 20;
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(16);
        this.setCurrentPage("1");
        boolean lastPage = false;
        this.setLastPage(lastPage);
        while (!lastPage) {
            EBBankDetailResponse response = this.doBiz(request);
            if (Objects.nonNull(response) && Objects.nonNull(response.getDetails())) {
                detailInfos.addAll(response.getDetails());
            }
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 20);
            lastPage = this.isLastPage();
        }
        return new EBBankDetailResponse(detailInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankDetailRequest request) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            BankAcnt acnt = request.getHeader().getAcnt();
            Element root = Packer.getHeader(token, "b2e0220");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0220-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0220-rq");
            JDomUtils.addChild((Element)rq, (String)"ibknum", (String)acnt.getAreaCode());
            JDomUtils.addChild((Element)rq, (String)"actacn", (String)acnt.getAccNo());
            String type = "2002";
            if (LocalDate.now().isEqual(request.getStartDate())) {
                type = "2001";
            }
            JDomUtils.addChild((Element)rq, (String)"type", (String)type);
            Element datescope = JDomUtils.addChild((Element)rq, (String)"datescope");
            JDomUtils.addChild((Element)datescope, (String)"from", (String)request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
            JDomUtils.addChild((Element)datescope, (String)"to", (String)request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
            Element amountscope = JDomUtils.addChild((Element)rq, (String)"amountscope");
            JDomUtils.addChild((Element)amountscope, (String)"from", (String)"0.01");
            JDomUtils.addChild((Element)amountscope, (String)"to", (String)"9999999999999");
            JDomUtils.addChild((Element)rq, (String)"begnum", (String)this.getCurrentPage());
            JDomUtils.addChild((Element)rq, (String)"recnum", (String)String.valueOf(20));
            JDomUtils.addChild((Element)rq, (String)"direction", (String)"A");
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0220-rs");
        Element status = trn.getChild("status");
        if (null != status) {
            String rspcod = status.getChildTextTrim("rspcod");
            String rspmsg = status.getChildTextTrim("rspmsg");
            if ("B001".equalsIgnoreCase(rspcod) || "B003".equalsIgnoreCase(rspcod)) {
                this.setLastPage(true);
            } else if ("B002".equalsIgnoreCase(rspcod)) {
                this.setLastPage(false);
            }
            if ("B003".equalsIgnoreCase(rspcod)) {
                return new EBBankDetailResponse(detailList);
            }
            if (!"B001".equalsIgnoreCase(rspcod) && !"B002".equalsIgnoreCase(rspcod)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25:%1$s\uff0c%2$s\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-boc-net-global", (Object[])new Object[0]), rspcod, rspmsg));
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u4e3a\u7a7a\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-boc-net-global", (Object[])new Object[0]));
        }
        Element totalnum = trn.getChild("totalnum");
        List list = trn.getChildren("b2e0220-rs");
        if (null == list || list.size() == 0) {
            return new EBBankDetailResponse(list);
        }
        for (Element record : list) {
            DetailInfo info;
            if (!"b2e0220-rs".equalsIgnoreCase(record.getName()) || (info = this.parseEachDetailB2e0220rs(record, request.getHeader().getAcnt())) == null) continue;
            detailList.add(info);
        }
        return new EBBankDetailResponse(detailList);
    }

    private DetailInfo parseEachDetailB2e0220rs(Element record, BankAcnt acnt) {
        Element status = record.getChild("status");
        Element rspCode = status.getChild("rspcod");
        if ("B001".equalsIgnoreCase(rspCode.getTextTrim())) {
            Element fractn = record.getChild("fractn");
            String payAcntNumber = fractn.getChildTextTrim("actacn");
            String payAcntName = fractn.getChildTextTrim("acntname");
            String payAcntBankName = fractn.getChildTextTrim("ibkname");
            BankAcnt payAcnt = new BankAcnt();
            payAcnt.setAccName(StrUtil.nullToEmpty((CharSequence)payAcntName));
            payAcnt.setAccNo(StrUtil.nullToEmpty((CharSequence)payAcntNumber));
            payAcnt.setBankName(StrUtil.nullToEmpty((CharSequence)payAcntBankName));
            Element toactn = record.getChild("toactn");
            String oppAcntNumber = toactn.getChildTextTrim("actacn");
            String oppAcntName = toactn.getChildTextTrim("toname");
            String oppAcntBankName = toactn.getChildTextTrim("tobank");
            BankAcnt oppPayAcnt = new BankAcnt();
            oppPayAcnt.setAccName(StrUtil.nullToEmpty((CharSequence)oppAcntName));
            oppPayAcnt.setAccNo(StrUtil.nullToEmpty((CharSequence)oppAcntNumber));
            oppPayAcnt.setBankName(StrUtil.nullToEmpty((CharSequence)oppAcntBankName));
            String transtype = record.getChildTextTrim("transtype");
            String insid = record.getChildTextTrim("insid");
            String reserve1 = record.getChildTextTrim("reserve1");
            String reserve2 = record.getChildTextTrim("reserve2");
            StringBuilder extMessage = new StringBuilder("EXT_MSG:");
            extMessage.append("insid=").append(insid).append(";reserve1=").append(reserve1).append(";reserve2=").append(reserve2);
            String txndate = record.getChildTextTrim("txndate");
            String txntime = record.getChildTextTrim("txntime");
            String txnamt = record.getChildTextTrim("txnamt");
            String trncur = record.getChildTextTrim("trncur");
            String acctbal = record.getChildTextTrim("acctbal");
            String useinfo = StrUtil.nullToEmpty((CharSequence)record.getChildTextTrim("useinfo"));
            String interinfo = StrUtil.nullToEmpty((CharSequence)record.getChildTextTrim("interinfo"));
            String direction = record.getChildText("direction");
            if (StrUtil.isEmpty((String)direction)) {
                this.log.info("[<direction> \u6765\u5f80\u8d26\u6807\u8bc6\uff08C-\u6765\u8d26\uff0cD-\u5f80\u8d26\uff09]\u8282\u70b9\u7684\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4ea4\u6613\u660e\u7ec6\u501f\u8d37\u65b9\u5411\u3002\u672c\u6761\u4ea4\u6613\u660e\u7ec6\u65e0\u6548\u3002");
                return null;
            }
            DetailInfo detail = new DetailInfo();
            if (StringUtils.isEmpty((String)txntime)) {
                txntime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss"));
            }
            detail.setTransDate(LocalDate.parse(txndate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setTransTime(LocalDateTime.parse(txndate + txntime.replaceAll(":", ""), DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            DetailSysFiled.set((DetailInfo)detail, (String)"businessName", (String)extMessage.toString());
            BigDecimal amt = new BigDecimal(txnamt);
            if ("11".equalsIgnoreCase(transtype)) {
                amt = amt.multiply(new BigDecimal("-1"));
            }
            if ("C".equalsIgnoreCase(direction)) {
                detail.setAccNo(oppPayAcnt.getAccNo());
                detail.setAccName(oppPayAcnt.getAccName());
                detail.setBankName(oppPayAcnt.getBankName());
                detail.setOppAccNo(payAcnt.getAccNo().replaceAll("/", ""));
                detail.setOppAccName(payAcnt.getAccName());
                detail.setOppBankName(payAcnt.getBankName());
                detail.setCreditAmount(amt);
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else if ("D".equalsIgnoreCase(direction)) {
                detail.setAccNo(payAcnt.getAccNo());
                detail.setAccName(payAcnt.getAccName());
                detail.setBankName(payAcnt.getBankName());
                detail.setOppAccNo(oppPayAcnt.getAccNo());
                detail.setOppAccName(oppPayAcnt.getAccName());
                detail.setOppBankName(oppPayAcnt.getBankName());
                detail.setCreditAmount(new BigDecimal("0.00"));
                detail.setDebitAmount(amt);
            } else {
                this.log.info("[<direction> \u6765\u5f80\u8d26\u6807\u8bc6\uff08C-\u6765\u8d26\uff0cD-\u5f80\u8d26\uff09]\u8282\u70b9\u7684\u503c[" + direction + "]\u672a\u77e5\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4ea4\u6613\u660e\u7ec6\u501f\u8d37\u65b9\u5411\u3002\u672c\u6761\u4ea4\u6613\u660e\u7ec6\u65e0\u6548\u3002");
                return null;
            }
            if (!StrUtil.isEmpty((String)acctbal)) {
                detail.setBalance(new BigDecimal(acctbal));
            }
            detail.setCurrency(trncur);
            if (!StrUtil.isEmpty((String)insid) && insid.indexOf("KD/") != -1) {
                String KDDetailNo = insid.substring(insid.indexOf("KD/") + "KD/".length());
                detail.setKdFlag(KDDetailNo);
                detail.setPayBankDetailSeqID(KDDetailNo);
            }
            detail.setExplanation(this.composeMsg(this.extractF(interinfo), this.extractA(interinfo), this.extractU(interinfo), this.extractR(interinfo)));
            String vchnum = record.getChildTextTrim("vchnum");
            if (!StrUtil.isEmpty((String)vchnum)) {
                detail.setBizRefNo(vchnum);
            }
            StringBuilder sBuffer = new StringBuilder();
            sBuffer.append(acnt.getAccNo()).append("-").append(txndate).append("-").append(vchnum);
            detail.setReceiptNo(sBuffer.toString());
            String billNo = record.getChildTextTrim("vouchnum");
            if (!StrUtil.isEmpty((String)billNo)) {
                detail.setVouhNo(billNo);
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
            detail.setJsonMap(jsonStr);
            detail.setBankDetailNo(vchnum);
            return detail;
        }
        this.log.info("\u5927\u5ba2\u6237\u4ea4\u6613\u4fe1\u606f\u67e5\u8be2\u94f6\u884c\u8fd4\u56de\u72b6\u6001(rspcod\u4e0d\u662fB001,\u94f6\u4f01\u4e0d\u5904\u7406)" + rspCode.getTextTrim() + "," + status.getTextTrim());
        return null;
    }

    private String extractU(String interinfo) {
        int endIndex;
        int index = interinfo.indexOf("//U:");
        if (-1 != index && index <= (endIndex = interinfo.indexOf("//R:", index))) {
            return interinfo.substring(index + 4, endIndex);
        }
        return "";
    }

    private String extractF(String interinfo) {
        int endIndex;
        int index = interinfo.indexOf("F:");
        if (-1 != index && index <= (endIndex = interinfo.indexOf("//A:", index))) {
            return interinfo.substring(index + 2, endIndex);
        }
        return "";
    }

    private String extractA(String interinfo) {
        int endIndex;
        int index = interinfo.indexOf("//A:");
        if (-1 != index && index <= (endIndex = interinfo.indexOf("//U:", index))) {
            return interinfo.substring(index + 4, endIndex);
        }
        return "";
    }

    private String extractR(String interinfo) {
        int index = interinfo.indexOf("//R:");
        if (-1 != index) {
            return interinfo.substring(index + 4);
        }
        return "";
    }

    private String composeMsg(String postscript, String explanation, String useCn, String beizhu) {
        String msg;
        int index;
        StringBuilder buffer = new StringBuilder();
        if (!StrUtil.isEmpty((String)postscript)) {
            buffer.append(postscript).append(',');
        }
        if (!StrUtil.isEmpty((String)explanation) && -1 == buffer.toString().indexOf(explanation) && !explanation.startsWith("OBSS")) {
            buffer.append(explanation).append(',');
        }
        if (!StrUtil.isEmpty((String)useCn) && -1 == buffer.toString().indexOf(useCn)) {
            buffer.append(useCn).append(',');
        }
        if (!StrUtil.isEmpty((String)beizhu) && -1 == buffer.toString().indexOf(beizhu)) {
            buffer.append(beizhu).append(',');
        }
        if (-1 != (index = (msg = buffer.toString()).lastIndexOf(","))) {
            msg = msg.substring(0, index);
        }
        return msg;
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "b2e0220";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5168\u7403\u8d26\u6237\u4ea4\u6613\u67e5\u8be2", (String)"DetailImpl_2", (String)"ebg-aqap-banks-boc-net-global", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }
}

