/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cexim.dc.services.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cexim.dc.services.login.LoginUtils;
import kd.ebg.aqap.banks.cexim.dc.util.CEXIMDCBankResponse;
import kd.ebg.aqap.banks.cexim.dc.util.CommonPacker;
import kd.ebg.aqap.banks.cexim.dc.util.CommonParser;
import kd.ebg.aqap.banks.cexim.dc.util.JDomExtUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class HisBatchBalanceImpl
extends AbstractBalanceImpl
implements IHisBatchBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        LoginUtils.login();
        List acnts = bankBalanceRequest.getBankAcntList();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element header = CommonPacker.createSystemHead(this.getBizCode());
        root.addContent((Content)header);
        Element request = CommonPacker.packInfoComEntity();
        body.addContent((Content)request);
        int size = acnts.size();
        JDomExtUtils.addChildCDData(request, "Rvl_Rcrd_Num", String.valueOf(size));
        for (int i = 0; i < size; ++i) {
            Element list1 = JDomExtUtils.addChild((Element)request, (String)"LIST1");
            list1.setAttribute("type", "G");
            JDomExtUtils.addChildCDData(list1, "AccNo", ((BankAcnt)acnts.get(i)).getAccNo());
            JDomExtUtils.addChildCDData(list1, "CCstTr_ID", EBContext.getContext().getParameter().getBankParameter("ccsttr_id"));
            JDomExtUtils.addChildCDData(list1, "CCstTrNdID", EBContext.getContext().getParameter().getBankParameter("ccsttrndd_id"));
        }
        JDomExtUtils.addChildCDData(request, "CcyCd", bankBalanceRequest.getBankCurrency());
        boolean isCNY = "156".equals(bankBalanceRequest.getBankCurrency());
        JDomExtUtils.addChildCDData(request, "CshEx_Cd", isCNY ? "1" : "2");
        JDomExtUtils.addChildCDData(request, "StDt", LocalDateUtil.formatDate((LocalDate)bankBalanceRequest.getStartDate(), (String)"yyyyMMdd"));
        JDomExtUtils.addChildCDData(request, "EdDt", LocalDateUtil.formatDate((LocalDate)bankBalanceRequest.getEndDate(), (String)"yyyyMMdd"));
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        CEXIMDCBankResponse bankResponse = CommonParser.getFrontResponse(rspStr);
        if (!bankResponse.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
        }
        rspStr = bankResponse.getBankMsg();
        CEXIMDCBankResponse bankResp = CommonParser.getBankPreResponse(bankResponse.getBankMsg());
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        EBBankBalanceResponse rsp = new EBBankBalanceResponse();
        BalanceInfo info = null;
        List list = response.getChildren("LIST1");
        int size = list.size();
        ArrayList<BalanceInfo> infos = new ArrayList<BalanceInfo>(16);
        for (int i = 0; i < size; ++i) {
            Element ele = (Element)list.get(i);
            String currency = JDomExtUtils.getChildText((Element)ele, (String)"CcyCd");
            String accAvlBal = JDomExtUtils.getChildText((Element)ele, (String)"Acc_Avl_Bal");
            String accBal = JDomExtUtils.getChildText((Element)ele, (String)"AcBa");
            String accNo = JDomExtUtils.getChildText((Element)ele, (String)"AccNo");
            String transDateStr = JDomExtUtils.getChildText((Element)ele, (String)"Txn_Dt");
            info = new BalanceInfo();
            infos.add(info);
            this.setBankAcnt(info, bankBalanceRequest.getBankAcntList(), accNo);
            this.setBankCurrency(info, bankBalanceRequest.getBankCurrency(), currency);
            this.setBalanceDateTime(info, transDateStr + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            this.setCurrentBalance(info, accBal);
            this.setAvailableBalance(info, accAvlBal);
        }
        rsp.setBalances(infos);
        return rsp;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "P1CMSER47";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d", (String)"HisBatchBalanceImpl_5", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]);
    }
}

