/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cexim.dc.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cexim.dc.services.login.LoginUtils;
import kd.ebg.aqap.banks.cexim.dc.util.CEXIMDCBankResponse;
import kd.ebg.aqap.banks.cexim.dc.util.CommonPacker;
import kd.ebg.aqap.banks.cexim.dc.util.CommonParser;
import kd.ebg.aqap.banks.cexim.dc.util.JDomExtUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import org.jdom2.Content;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        LoginUtils.login();
        BankAcnt acnt = (BankAcnt)bankBalanceRequest.getBankAcntList().get(0);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element header = CommonPacker.createSystemHead(this.getBizCode());
        root.addContent((Content)header);
        Element request = CommonPacker.packInfoComEntity();
        body.addContent((Content)request);
        JDomExtUtils.addChildCDData(request, "Cst_AccNo", acnt.getAccNo());
        JDomExtUtils.addChildCDData(request, "CcyCd", bankBalanceRequest.getBankCurrency());
        boolean isCNY = "156".equals(bankBalanceRequest.getBankCurrency());
        JDomExtUtils.addChildCDData(request, "CshEx_Cd", isCNY ? "1" : "2");
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        CEXIMDCBankResponse bankResponse = CommonParser.getFrontResponse(rspStr);
        if (!bankResponse.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
        }
        rspStr = bankResponse.getBankMsg();
        CEXIMDCBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        EBBankBalanceResponse rsp = new EBBankBalanceResponse();
        BalanceInfo info = new BalanceInfo();
        String accNo = JDomExtUtils.getChildText((Element)response, (String)"Cst_AccNo");
        this.setBankAcnt(info, bankBalanceRequest.getBankAcntList(), accNo);
        String currency = JDomExtUtils.getChildText((Element)response, (String)"CcyCd");
        this.setBankCurrency(info, bankBalanceRequest.getBankCurrency(), currency);
        String accAvlBal = JDomExtUtils.getChildText((Element)response, (String)"Avl_Bal");
        this.setAvailableBalance(info, accAvlBal);
        String accBal = JDomExtUtils.getChildText((Element)response, (String)"Dep_AcBa");
        this.setCurrentBalance(info, accBal);
        info.setBalanceDateTime(LocalDateTime.now());
        ArrayList<BalanceInfo> infos = new ArrayList<BalanceInfo>(16);
        infos.add(info);
        rsp.setBalances(infos);
        return rsp;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "P1CMSER43";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]);
    }
}

