/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cexim.dc.services.payment.batch;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cexim.dc.services.login.LoginUtils;
import kd.ebg.aqap.banks.cexim.dc.services.payment.batch.QueryBatchPayImpl;
import kd.ebg.aqap.banks.cexim.dc.util.CEXIMDCBankResponse;
import kd.ebg.aqap.banks.cexim.dc.util.CommonPacker;
import kd.ebg.aqap.banks.cexim.dc.util.CommonParser;
import kd.ebg.aqap.banks.cexim.dc.util.FileInfoNode;
import kd.ebg.aqap.banks.cexim.dc.util.FileUtils;
import kd.ebg.aqap.banks.cexim.dc.util.JDomExtUtils;
import kd.ebg.aqap.banks.cexim.dc.util.PaymentUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class BatchPayImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BatchPayImpl.class);

    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryBatchPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        LoginUtils.login();
        String bizSeqId = bankPayRequest.getHeader().getBizSeqID();
        List paymentInfos = bankPayRequest.getPaymentInfos();
        FileUtils fileUtils = new FileUtils();
        FileInfoNode fileInfoNode = fileUtils.getFileInfoNodes(paymentInfos);
        String message = "";
        try {
            this.logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb:\u6587\u4ef6\u540d=" + fileInfoNode.getFileName() + "");
            message = fileUtils.uploadFile(bizSeqId, fileInfoNode);
            this.logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6210\u529f.\u6587\u4ef6\u5185\u5bb9\uff1a");
            this.logger.info(fileInfoNode.getFileContent());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u751f\u6210\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (String)"BatchPayImpl_0", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), (Throwable)e);
        }
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element header = CommonPacker.createSystemHead(this.getBizCode());
        root.addContent((Content)header);
        Element request = CommonPacker.packPayComEntity(paymentInfo.getBatchSeqID());
        body.addContent((Content)request);
        CommonPacker.packFileEntity(request, fileInfoNode, message);
        JDomExtUtils.addChildCDData(request, "Btch_Nm", paymentInfo.getBatchSeqID());
        JDomExtUtils.addChildCDData(request, "Cst_Dlv_Dt", LocalDateUtil.formatDate((LocalDate)LocalDate.now(), (String)"yyyyMMdd"));
        JDomExtUtils.addChildCDData(request, "Cst_Dlv_Tm", LocalDateUtil.formatDate((LocalDateTime)LocalDateTime.now(), (String)"hhmmssSSS"));
        JDomExtUtils.addChildCDData(request, "RvPy_ExMd_Cd", "0");
        JDomExtUtils.addChildCDData(request, "Btch_TDnum", String.valueOf(paymentInfo.getTotalCount()));
        JDomExtUtils.addChildCDData(request, "TAmt", paymentInfo.getTotalAmount().toString());
        JDomExtUtils.addChildCDData(request, "CstPty_TxnSrlNo", PaymentUtils.getKDByBatch(paymentInfo));
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        CEXIMDCBankResponse bankResponse = CommonParser.getFrontResponse(responseStr);
        if (!bankResponse.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%s", (String)"BatchPayImpl_1", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), bankResponse.getResponseCode() + bankResponse.getResponseMessage()));
        }
        responseStr = bankResponse.getBankMsg();
        EBBankPayResponse ebBankPayResponse = new EBBankPayResponse();
        List paymentInfos = request.getPaymentInfos();
        CEXIMDCBankResponse bankResp = CommonParser.getBankPreResponse(responseStr);
        if (!bankResp.isSuccess()) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
            return ebBankPayResponse;
        }
        Element root = JDomExtUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)"");
        ebBankPayResponse.setPaymentInfos(paymentInfos);
        return ebBankPayResponse;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "P1CMSET42";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4eba\u6c11\u5e01\u6279\u91cf\u4ed8\u6b3e", (String)"BatchPayImpl_2", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return PaymentUtils.isCompany(paymentInfo) && paymentInfo.getTotalCount() > 1;
    }
}

