/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.LinkPayStepInfo;
import kd.ebg.aqap.common.model.LinkPaymentInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.LinkPaymentInfoRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;

@Service
public class LinkPaymentInfoService {
    EBGLogger log = EBGLogger.getInstance().getLogger(LinkPaymentInfoService.class);
    @Autowired
    private LinkPaymentInfoRepository linkPaymentInfoRepository;

    public static LinkPaymentInfoService getInstance() {
        return SpringContextUtil.getBean(LinkPaymentInfoService.class);
    }

    public List<LinkPaymentInfo> selectByBatchSeqId(String batchSeqId) {
        return this.linkPaymentInfoRepository.findByBatchSeqId(batchSeqId);
    }

    public List<LinkPaymentInfo> selectByBatchSeqIdAndDetailSeqId(String batchSeqId, String detailSeqId) {
        return this.linkPaymentInfoRepository.findByBatchSeqIdAndDetailSeqId(batchSeqId, detailSeqId);
    }

    public List<LinkPaymentInfo> updateLinkPaymentInfo(List<LinkPaymentInfo> linkPaymentInfos) {
        this.linkPaymentInfoRepository.save(linkPaymentInfos);
        return linkPaymentInfos;
    }

    public void linkpayWithTransaction(List<LinkPayStepInfo> linkPayStepInfos) {
        ArrayList<PaymentInfo> stepOnePaymentList = new ArrayList<PaymentInfo>(16);
        ArrayList<LinkPaymentInfo> linkPayDetails = new ArrayList<LinkPaymentInfo>(16);
        for (LinkPayStepInfo linkPayStepInfo : linkPayStepInfos) {
            PaymentInfo stepOnePayment = linkPayStepInfo.getStepOnePayment();
            stepOnePayment.setInsertTime(LocalDateTime.now());
            stepOnePayment.setSyncCount(0);
            stepOnePayment.setEbgID(SpringContextUtil.getBean(SingleNodeIDGetter.class).nodeID());
            stepOnePaymentList.add(stepOnePayment);
            linkPayDetails.addAll(linkPayStepInfo.getLinkPayDetails());
        }
        linkPayDetails.forEach(linkPaymentInfo -> {
            linkPaymentInfo.setId(Sequence.gen18Sequence());
            linkPaymentInfo.setCreateTime(LocalDateTime.now());
            linkPaymentInfo.setUpdateTime(LocalDateTime.now());
            linkPaymentInfo.setEbgId(SpringContextUtil.getBean(SingleNodeIDGetter.class).nodeID());
        });
        try (TXHandle h = TX.requiresNew();){
            this.linkPaymentInfoRepository.save(linkPayDetails);
            PaymentInfoService.getInstance().save(stepOnePaymentList, true);
        }
    }

    public boolean batchSeqIDExist(String batchSeqID) {
        return this.countByBatchSeqID(batchSeqID) > 0L;
    }

    public long countByBatchSeqID(String batchSeqID) {
        QFilter filter = QFilter.of((String)"batch_seq_id = ?", (Object[])new Object[]{batchSeqID});
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"aqap_bd_linkpaymentinfo", (String)"id", (QFilter[])filter.toArray(), (String)"");
        long total = ds.count("id", Boolean.FALSE.booleanValue());
        return total;
    }

    public boolean isExisted(String batchSeqID) {
        QFilter filter = QFilter.of((String)"batch_seq_id = ?", (Object[])new Object[]{batchSeqID});
        return QueryServiceHelper.exists((String)"aqap_bd_linkpaymentinfo", (QFilter[])filter.toArray());
    }
}

